package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.{
  Id,
  ApplicationVersionId,
  ApplicationName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteApplicationCloudWatchLoggingOptionRequest(
    applicationName: ApplicationName,
    currentApplicationVersionId: ApplicationVersionId,
    cloudWatchLoggingOptionId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationCloudWatchLoggingOptionRequest = {
    import DeleteApplicationCloudWatchLoggingOptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationCloudWatchLoggingOptionRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .currentApplicationVersionId(
        ApplicationVersionId.unwrap(currentApplicationVersionId): java.lang.Long
      )
      .cloudWatchLoggingOptionId(
        Id.unwrap(cloudWatchLoggingOptionId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalytics.model.DeleteApplicationCloudWatchLoggingOptionRequest.ReadOnly =
    zio.aws.kinesisanalytics.model.DeleteApplicationCloudWatchLoggingOptionRequest
      .wrap(buildAwsValue())
}
object DeleteApplicationCloudWatchLoggingOptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationCloudWatchLoggingOptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalytics.model.DeleteApplicationCloudWatchLoggingOptionRequest =
      zio.aws.kinesisanalytics.model
        .DeleteApplicationCloudWatchLoggingOptionRequest(
          applicationName,
          currentApplicationVersionId,
          cloudWatchLoggingOptionId
        )
    def applicationName: ApplicationName
    def currentApplicationVersionId: ApplicationVersionId
    def cloudWatchLoggingOptionId: Id
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getCurrentApplicationVersionId
        : ZIO[Any, Nothing, ApplicationVersionId] =
      ZIO.succeed(currentApplicationVersionId)
    def getCloudWatchLoggingOptionId: ZIO[Any, Nothing, Id] =
      ZIO.succeed(cloudWatchLoggingOptionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationCloudWatchLoggingOptionRequest
  ) extends zio.aws.kinesisanalytics.model.DeleteApplicationCloudWatchLoggingOptionRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.kinesisanalytics.model.primitives
        .ApplicationName(impl.applicationName())
    override val currentApplicationVersionId: ApplicationVersionId =
      zio.aws.kinesisanalytics.model.primitives
        .ApplicationVersionId(impl.currentApplicationVersionId())
    override val cloudWatchLoggingOptionId: Id =
      zio.aws.kinesisanalytics.model.primitives
        .Id(impl.cloudWatchLoggingOptionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationCloudWatchLoggingOptionRequest
  ): zio.aws.kinesisanalytics.model.DeleteApplicationCloudWatchLoggingOptionRequest.ReadOnly =
    new Wrapper(impl)
}
