package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.{InAppStreamName, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InputUpdate(
    inputId: Id,
    namePrefixUpdate: Optional[InAppStreamName] = Optional.Absent,
    inputProcessingConfigurationUpdate: Optional[
      zio.aws.kinesisanalytics.model.InputProcessingConfigurationUpdate
    ] = Optional.Absent,
    kinesisStreamsInputUpdate: Optional[
      zio.aws.kinesisanalytics.model.KinesisStreamsInputUpdate
    ] = Optional.Absent,
    kinesisFirehoseInputUpdate: Optional[
      zio.aws.kinesisanalytics.model.KinesisFirehoseInputUpdate
    ] = Optional.Absent,
    inputSchemaUpdate: Optional[
      zio.aws.kinesisanalytics.model.InputSchemaUpdate
    ] = Optional.Absent,
    inputParallelismUpdate: Optional[
      zio.aws.kinesisanalytics.model.InputParallelismUpdate
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.InputUpdate = {
    import InputUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.InputUpdate
      .builder()
      .inputId(Id.unwrap(inputId): java.lang.String)
      .optionallyWith(
        namePrefixUpdate.map(value =>
          InAppStreamName.unwrap(value): java.lang.String
        )
      )(_.namePrefixUpdate)
      .optionallyWith(
        inputProcessingConfigurationUpdate.map(value => value.buildAwsValue())
      )(_.inputProcessingConfigurationUpdate)
      .optionallyWith(
        kinesisStreamsInputUpdate.map(value => value.buildAwsValue())
      )(_.kinesisStreamsInputUpdate)
      .optionallyWith(
        kinesisFirehoseInputUpdate.map(value => value.buildAwsValue())
      )(_.kinesisFirehoseInputUpdate)
      .optionallyWith(inputSchemaUpdate.map(value => value.buildAwsValue()))(
        _.inputSchemaUpdate
      )
      .optionallyWith(
        inputParallelismUpdate.map(value => value.buildAwsValue())
      )(_.inputParallelismUpdate)
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalytics.model.InputUpdate.ReadOnly =
    zio.aws.kinesisanalytics.model.InputUpdate.wrap(buildAwsValue())
}
object InputUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.InputUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.InputUpdate =
      zio.aws.kinesisanalytics.model.InputUpdate(
        inputId,
        namePrefixUpdate.map(value => value),
        inputProcessingConfigurationUpdate.map(value => value.asEditable),
        kinesisStreamsInputUpdate.map(value => value.asEditable),
        kinesisFirehoseInputUpdate.map(value => value.asEditable),
        inputSchemaUpdate.map(value => value.asEditable),
        inputParallelismUpdate.map(value => value.asEditable)
      )
    def inputId: Id
    def namePrefixUpdate: Optional[InAppStreamName]
    def inputProcessingConfigurationUpdate: Optional[
      zio.aws.kinesisanalytics.model.InputProcessingConfigurationUpdate.ReadOnly
    ]
    def kinesisStreamsInputUpdate: Optional[
      zio.aws.kinesisanalytics.model.KinesisStreamsInputUpdate.ReadOnly
    ]
    def kinesisFirehoseInputUpdate: Optional[
      zio.aws.kinesisanalytics.model.KinesisFirehoseInputUpdate.ReadOnly
    ]
    def inputSchemaUpdate
        : Optional[zio.aws.kinesisanalytics.model.InputSchemaUpdate.ReadOnly]
    def inputParallelismUpdate: Optional[
      zio.aws.kinesisanalytics.model.InputParallelismUpdate.ReadOnly
    ]
    def getInputId: ZIO[Any, Nothing, Id] = ZIO.succeed(inputId)
    def getNamePrefixUpdate: ZIO[Any, AwsError, InAppStreamName] =
      AwsError.unwrapOptionField("namePrefixUpdate", namePrefixUpdate)
    def getInputProcessingConfigurationUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.InputProcessingConfigurationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inputProcessingConfigurationUpdate",
      inputProcessingConfigurationUpdate
    )
    def getKinesisStreamsInputUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.KinesisStreamsInputUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kinesisStreamsInputUpdate",
      kinesisStreamsInputUpdate
    )
    def getKinesisFirehoseInputUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.KinesisFirehoseInputUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kinesisFirehoseInputUpdate",
      kinesisFirehoseInputUpdate
    )
    def getInputSchemaUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.InputSchemaUpdate.ReadOnly
    ] = AwsError.unwrapOptionField("inputSchemaUpdate", inputSchemaUpdate)
    def getInputParallelismUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.InputParallelismUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inputParallelismUpdate",
      inputParallelismUpdate
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.InputUpdate
  ) extends zio.aws.kinesisanalytics.model.InputUpdate.ReadOnly {
    override val inputId: Id =
      zio.aws.kinesisanalytics.model.primitives.Id(impl.inputId())
    override val namePrefixUpdate: Optional[InAppStreamName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.namePrefixUpdate())
        .map(value =>
          zio.aws.kinesisanalytics.model.primitives.InAppStreamName(value)
        )
    override val inputProcessingConfigurationUpdate: Optional[
      zio.aws.kinesisanalytics.model.InputProcessingConfigurationUpdate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.inputProcessingConfigurationUpdate())
      .map(value =>
        zio.aws.kinesisanalytics.model.InputProcessingConfigurationUpdate
          .wrap(value)
      )
    override val kinesisStreamsInputUpdate: Optional[
      zio.aws.kinesisanalytics.model.KinesisStreamsInputUpdate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.kinesisStreamsInputUpdate())
      .map(value =>
        zio.aws.kinesisanalytics.model.KinesisStreamsInputUpdate.wrap(value)
      )
    override val kinesisFirehoseInputUpdate: Optional[
      zio.aws.kinesisanalytics.model.KinesisFirehoseInputUpdate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.kinesisFirehoseInputUpdate())
      .map(value =>
        zio.aws.kinesisanalytics.model.KinesisFirehoseInputUpdate.wrap(value)
      )
    override val inputSchemaUpdate
        : Optional[zio.aws.kinesisanalytics.model.InputSchemaUpdate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputSchemaUpdate())
        .map(value =>
          zio.aws.kinesisanalytics.model.InputSchemaUpdate.wrap(value)
        )
    override val inputParallelismUpdate: Optional[
      zio.aws.kinesisanalytics.model.InputParallelismUpdate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.inputParallelismUpdate())
      .map(value =>
        zio.aws.kinesisanalytics.model.InputParallelismUpdate.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.InputUpdate
  ): zio.aws.kinesisanalytics.model.InputUpdate.ReadOnly = new Wrapper(impl)
}
