package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.{RoleARN, LogStreamARN}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CloudWatchLoggingOption(
    logStreamARN: LogStreamARN,
    roleARN: RoleARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOption = {
    import CloudWatchLoggingOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOption
      .builder()
      .logStreamARN(LogStreamARN.unwrap(logStreamARN): java.lang.String)
      .roleARN(RoleARN.unwrap(roleARN): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalytics.model.CloudWatchLoggingOption.ReadOnly =
    zio.aws.kinesisanalytics.model.CloudWatchLoggingOption.wrap(buildAwsValue())
}
object CloudWatchLoggingOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.CloudWatchLoggingOption =
      zio.aws.kinesisanalytics.model
        .CloudWatchLoggingOption(logStreamARN, roleARN)
    def logStreamARN: LogStreamARN
    def roleARN: RoleARN
    def getLogStreamARN: ZIO[Any, Nothing, LogStreamARN] =
      ZIO.succeed(logStreamARN)
    def getRoleARN: ZIO[Any, Nothing, RoleARN] = ZIO.succeed(roleARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOption
  ) extends zio.aws.kinesisanalytics.model.CloudWatchLoggingOption.ReadOnly {
    override val logStreamARN: LogStreamARN =
      zio.aws.kinesisanalytics.model.primitives
        .LogStreamARN(impl.logStreamARN())
    override val roleARN: RoleARN =
      zio.aws.kinesisanalytics.model.primitives.RoleARN(impl.roleARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOption
  ): zio.aws.kinesisanalytics.model.CloudWatchLoggingOption.ReadOnly =
    new Wrapper(impl)
}
