package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.KinesisAnalyticsARN
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(resourceARN: KinesisAnalyticsARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.ListTagsForResourceRequest
      .builder()
      .resourceARN(KinesisAnalyticsARN.unwrap(resourceARN): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalytics.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.kinesisanalytics.model.ListTagsForResourceRequest
      .wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.ListTagsForResourceRequest =
      zio.aws.kinesisanalytics.model.ListTagsForResourceRequest(resourceARN)
    def resourceARN: KinesisAnalyticsARN
    def getResourceARN: ZIO[Any, Nothing, KinesisAnalyticsARN] =
      ZIO.succeed(resourceARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.ListTagsForResourceRequest
  ) extends zio.aws.kinesisanalytics.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceARN: KinesisAnalyticsARN =
      zio.aws.kinesisanalytics.model.primitives
        .KinesisAnalyticsARN(impl.resourceARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.ListTagsForResourceRequest
  ): zio.aws.kinesisanalytics.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
