package zio.aws.kinesisanalytics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeApplicationResponse(
    applicationDetail: zio.aws.kinesisanalytics.model.ApplicationDetail
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.DescribeApplicationResponse = {
    import DescribeApplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.DescribeApplicationResponse
      .builder()
      .applicationDetail(applicationDetail.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalytics.model.DescribeApplicationResponse.ReadOnly =
    zio.aws.kinesisanalytics.model.DescribeApplicationResponse
      .wrap(buildAwsValue())
}
object DescribeApplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.DescribeApplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.DescribeApplicationResponse =
      zio.aws.kinesisanalytics.model
        .DescribeApplicationResponse(applicationDetail.asEditable)
    def applicationDetail
        : zio.aws.kinesisanalytics.model.ApplicationDetail.ReadOnly
    def getApplicationDetail: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisanalytics.model.ApplicationDetail.ReadOnly
    ] = ZIO.succeed(applicationDetail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.DescribeApplicationResponse
  ) extends zio.aws.kinesisanalytics.model.DescribeApplicationResponse.ReadOnly {
    override val applicationDetail
        : zio.aws.kinesisanalytics.model.ApplicationDetail.ReadOnly =
      zio.aws.kinesisanalytics.model.ApplicationDetail
        .wrap(impl.applicationDetail())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.DescribeApplicationResponse
  ): zio.aws.kinesisanalytics.model.DescribeApplicationResponse.ReadOnly =
    new Wrapper(impl)
}
