package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.{
  ApplicationVersionId,
  ApplicationName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AddApplicationOutputRequest(
    applicationName: ApplicationName,
    currentApplicationVersionId: ApplicationVersionId,
    output: zio.aws.kinesisanalytics.model.Output
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationOutputRequest = {
    import AddApplicationOutputRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationOutputRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .currentApplicationVersionId(
        ApplicationVersionId.unwrap(currentApplicationVersionId): java.lang.Long
      )
      .output(output.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalytics.model.AddApplicationOutputRequest.ReadOnly =
    zio.aws.kinesisanalytics.model.AddApplicationOutputRequest
      .wrap(buildAwsValue())
}
object AddApplicationOutputRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationOutputRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.AddApplicationOutputRequest =
      zio.aws.kinesisanalytics.model.AddApplicationOutputRequest(
        applicationName,
        currentApplicationVersionId,
        output.asEditable
      )
    def applicationName: ApplicationName
    def currentApplicationVersionId: ApplicationVersionId
    def output: zio.aws.kinesisanalytics.model.Output.ReadOnly
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getCurrentApplicationVersionId
        : ZIO[Any, Nothing, ApplicationVersionId] =
      ZIO.succeed(currentApplicationVersionId)
    def getOutput
        : ZIO[Any, Nothing, zio.aws.kinesisanalytics.model.Output.ReadOnly] =
      ZIO.succeed(output)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationOutputRequest
  ) extends zio.aws.kinesisanalytics.model.AddApplicationOutputRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.kinesisanalytics.model.primitives
        .ApplicationName(impl.applicationName())
    override val currentApplicationVersionId: ApplicationVersionId =
      zio.aws.kinesisanalytics.model.primitives
        .ApplicationVersionId(impl.currentApplicationVersionId())
    override val output: zio.aws.kinesisanalytics.model.Output.ReadOnly =
      zio.aws.kinesisanalytics.model.Output.wrap(impl.output())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationOutputRequest
  ): zio.aws.kinesisanalytics.model.AddApplicationOutputRequest.ReadOnly =
    new Wrapper(impl)
}
