package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.KinesisAnalyticsARN
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceARN: KinesisAnalyticsARN,
    tags: Iterable[zio.aws.kinesisanalytics.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.TagResourceRequest
      .builder()
      .resourceARN(KinesisAnalyticsARN.unwrap(resourceARN): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalytics.model.TagResourceRequest.ReadOnly =
    zio.aws.kinesisanalytics.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.TagResourceRequest =
      zio.aws.kinesisanalytics.model.TagResourceRequest(
        resourceARN,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceARN: KinesisAnalyticsARN
    def tags: List[zio.aws.kinesisanalytics.model.Tag.ReadOnly]
    def getResourceARN: ZIO[Any, Nothing, KinesisAnalyticsARN] =
      ZIO.succeed(resourceARN)
    def getTags
        : ZIO[Any, Nothing, List[zio.aws.kinesisanalytics.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.TagResourceRequest
  ) extends zio.aws.kinesisanalytics.model.TagResourceRequest.ReadOnly {
    override val resourceARN: KinesisAnalyticsARN =
      zio.aws.kinesisanalytics.model.primitives
        .KinesisAnalyticsARN(impl.resourceARN())
    override val tags: List[zio.aws.kinesisanalytics.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.kinesisanalytics.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.TagResourceRequest
  ): zio.aws.kinesisanalytics.model.TagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
