package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.{
  ApplicationVersionId,
  ApplicationName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AddApplicationCloudWatchLoggingOptionRequest(
    applicationName: ApplicationName,
    currentApplicationVersionId: ApplicationVersionId,
    cloudWatchLoggingOption: zio.aws.kinesisanalytics.model.CloudWatchLoggingOption
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationCloudWatchLoggingOptionRequest = {
    import AddApplicationCloudWatchLoggingOptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationCloudWatchLoggingOptionRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .currentApplicationVersionId(
        ApplicationVersionId.unwrap(currentApplicationVersionId): java.lang.Long
      )
      .cloudWatchLoggingOption(cloudWatchLoggingOption.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalytics.model.AddApplicationCloudWatchLoggingOptionRequest.ReadOnly =
    zio.aws.kinesisanalytics.model.AddApplicationCloudWatchLoggingOptionRequest
      .wrap(buildAwsValue())
}
object AddApplicationCloudWatchLoggingOptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationCloudWatchLoggingOptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalytics.model.AddApplicationCloudWatchLoggingOptionRequest =
      zio.aws.kinesisanalytics.model
        .AddApplicationCloudWatchLoggingOptionRequest(
          applicationName,
          currentApplicationVersionId,
          cloudWatchLoggingOption.asEditable
        )
    def applicationName: ApplicationName
    def currentApplicationVersionId: ApplicationVersionId
    def cloudWatchLoggingOption
        : zio.aws.kinesisanalytics.model.CloudWatchLoggingOption.ReadOnly
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getCurrentApplicationVersionId
        : ZIO[Any, Nothing, ApplicationVersionId] =
      ZIO.succeed(currentApplicationVersionId)
    def getCloudWatchLoggingOption: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisanalytics.model.CloudWatchLoggingOption.ReadOnly
    ] = ZIO.succeed(cloudWatchLoggingOption)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationCloudWatchLoggingOptionRequest
  ) extends zio.aws.kinesisanalytics.model.AddApplicationCloudWatchLoggingOptionRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.kinesisanalytics.model.primitives
        .ApplicationName(impl.applicationName())
    override val currentApplicationVersionId: ApplicationVersionId =
      zio.aws.kinesisanalytics.model.primitives
        .ApplicationVersionId(impl.currentApplicationVersionId())
    override val cloudWatchLoggingOption
        : zio.aws.kinesisanalytics.model.CloudWatchLoggingOption.ReadOnly =
      zio.aws.kinesisanalytics.model.CloudWatchLoggingOption
        .wrap(impl.cloudWatchLoggingOption())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationCloudWatchLoggingOptionRequest
  ): zio.aws.kinesisanalytics.model.AddApplicationCloudWatchLoggingOptionRequest.ReadOnly =
    new Wrapper(impl)
}
