package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.{InAppStreamName, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InputDescription(
    inputId: Optional[Id] = Optional.Absent,
    namePrefix: Optional[InAppStreamName] = Optional.Absent,
    inAppStreamNames: Optional[Iterable[InAppStreamName]] = Optional.Absent,
    inputProcessingConfigurationDescription: Optional[
      zio.aws.kinesisanalytics.model.InputProcessingConfigurationDescription
    ] = Optional.Absent,
    kinesisStreamsInputDescription: Optional[
      zio.aws.kinesisanalytics.model.KinesisStreamsInputDescription
    ] = Optional.Absent,
    kinesisFirehoseInputDescription: Optional[
      zio.aws.kinesisanalytics.model.KinesisFirehoseInputDescription
    ] = Optional.Absent,
    inputSchema: Optional[zio.aws.kinesisanalytics.model.SourceSchema] =
      Optional.Absent,
    inputParallelism: Optional[
      zio.aws.kinesisanalytics.model.InputParallelism
    ] = Optional.Absent,
    inputStartingPositionConfiguration: Optional[
      zio.aws.kinesisanalytics.model.InputStartingPositionConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.InputDescription = {
    import InputDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.InputDescription
      .builder()
      .optionallyWith(inputId.map(value => Id.unwrap(value): java.lang.String))(
        _.inputId
      )
      .optionallyWith(
        namePrefix.map(value => InAppStreamName.unwrap(value): java.lang.String)
      )(_.namePrefix)
      .optionallyWith(
        inAppStreamNames.map(value =>
          value.map { item =>
            InAppStreamName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.inAppStreamNames)
      .optionallyWith(
        inputProcessingConfigurationDescription.map(value =>
          value.buildAwsValue()
        )
      )(_.inputProcessingConfigurationDescription)
      .optionallyWith(
        kinesisStreamsInputDescription.map(value => value.buildAwsValue())
      )(_.kinesisStreamsInputDescription)
      .optionallyWith(
        kinesisFirehoseInputDescription.map(value => value.buildAwsValue())
      )(_.kinesisFirehoseInputDescription)
      .optionallyWith(inputSchema.map(value => value.buildAwsValue()))(
        _.inputSchema
      )
      .optionallyWith(inputParallelism.map(value => value.buildAwsValue()))(
        _.inputParallelism
      )
      .optionallyWith(
        inputStartingPositionConfiguration.map(value => value.buildAwsValue())
      )(_.inputStartingPositionConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalytics.model.InputDescription.ReadOnly =
    zio.aws.kinesisanalytics.model.InputDescription.wrap(buildAwsValue())
}
object InputDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.InputDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.InputDescription =
      zio.aws.kinesisanalytics.model.InputDescription(
        inputId.map(value => value),
        namePrefix.map(value => value),
        inAppStreamNames.map(value => value),
        inputProcessingConfigurationDescription.map(value => value.asEditable),
        kinesisStreamsInputDescription.map(value => value.asEditable),
        kinesisFirehoseInputDescription.map(value => value.asEditable),
        inputSchema.map(value => value.asEditable),
        inputParallelism.map(value => value.asEditable),
        inputStartingPositionConfiguration.map(value => value.asEditable)
      )
    def inputId: Optional[Id]
    def namePrefix: Optional[InAppStreamName]
    def inAppStreamNames: Optional[List[InAppStreamName]]
    def inputProcessingConfigurationDescription: Optional[
      zio.aws.kinesisanalytics.model.InputProcessingConfigurationDescription.ReadOnly
    ]
    def kinesisStreamsInputDescription: Optional[
      zio.aws.kinesisanalytics.model.KinesisStreamsInputDescription.ReadOnly
    ]
    def kinesisFirehoseInputDescription: Optional[
      zio.aws.kinesisanalytics.model.KinesisFirehoseInputDescription.ReadOnly
    ]
    def inputSchema
        : Optional[zio.aws.kinesisanalytics.model.SourceSchema.ReadOnly]
    def inputParallelism
        : Optional[zio.aws.kinesisanalytics.model.InputParallelism.ReadOnly]
    def inputStartingPositionConfiguration: Optional[
      zio.aws.kinesisanalytics.model.InputStartingPositionConfiguration.ReadOnly
    ]
    def getInputId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("inputId", inputId)
    def getNamePrefix: ZIO[Any, AwsError, InAppStreamName] =
      AwsError.unwrapOptionField("namePrefix", namePrefix)
    def getInAppStreamNames: ZIO[Any, AwsError, List[InAppStreamName]] =
      AwsError.unwrapOptionField("inAppStreamNames", inAppStreamNames)
    def getInputProcessingConfigurationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.InputProcessingConfigurationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inputProcessingConfigurationDescription",
      inputProcessingConfigurationDescription
    )
    def getKinesisStreamsInputDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.KinesisStreamsInputDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kinesisStreamsInputDescription",
      kinesisStreamsInputDescription
    )
    def getKinesisFirehoseInputDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.KinesisFirehoseInputDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kinesisFirehoseInputDescription",
      kinesisFirehoseInputDescription
    )
    def getInputSchema: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.SourceSchema.ReadOnly
    ] = AwsError.unwrapOptionField("inputSchema", inputSchema)
    def getInputParallelism: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.InputParallelism.ReadOnly
    ] = AwsError.unwrapOptionField("inputParallelism", inputParallelism)
    def getInputStartingPositionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.InputStartingPositionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inputStartingPositionConfiguration",
      inputStartingPositionConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.InputDescription
  ) extends zio.aws.kinesisanalytics.model.InputDescription.ReadOnly {
    override val inputId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.inputId())
      .map(value => zio.aws.kinesisanalytics.model.primitives.Id(value))
    override val namePrefix: Optional[InAppStreamName] = zio.aws.core.internal
      .optionalFromNullable(impl.namePrefix())
      .map(value =>
        zio.aws.kinesisanalytics.model.primitives.InAppStreamName(value)
      )
    override val inAppStreamNames: Optional[List[InAppStreamName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inAppStreamNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kinesisanalytics.model.primitives.InAppStreamName(item)
          }.toList
        )
    override val inputProcessingConfigurationDescription: Optional[
      zio.aws.kinesisanalytics.model.InputProcessingConfigurationDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.inputProcessingConfigurationDescription())
      .map(value =>
        zio.aws.kinesisanalytics.model.InputProcessingConfigurationDescription
          .wrap(value)
      )
    override val kinesisStreamsInputDescription: Optional[
      zio.aws.kinesisanalytics.model.KinesisStreamsInputDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.kinesisStreamsInputDescription())
      .map(value =>
        zio.aws.kinesisanalytics.model.KinesisStreamsInputDescription
          .wrap(value)
      )
    override val kinesisFirehoseInputDescription: Optional[
      zio.aws.kinesisanalytics.model.KinesisFirehoseInputDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.kinesisFirehoseInputDescription())
      .map(value =>
        zio.aws.kinesisanalytics.model.KinesisFirehoseInputDescription
          .wrap(value)
      )
    override val inputSchema
        : Optional[zio.aws.kinesisanalytics.model.SourceSchema.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputSchema())
        .map(value => zio.aws.kinesisanalytics.model.SourceSchema.wrap(value))
    override val inputParallelism
        : Optional[zio.aws.kinesisanalytics.model.InputParallelism.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputParallelism())
        .map(value =>
          zio.aws.kinesisanalytics.model.InputParallelism.wrap(value)
        )
    override val inputStartingPositionConfiguration: Optional[
      zio.aws.kinesisanalytics.model.InputStartingPositionConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.inputStartingPositionConfiguration())
      .map(value =>
        zio.aws.kinesisanalytics.model.InputStartingPositionConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.InputDescription
  ): zio.aws.kinesisanalytics.model.InputDescription.ReadOnly = new Wrapper(
    impl
  )
}
