package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.{RoleARN, ResourceARN}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LambdaOutputUpdate(
    resourceARNUpdate: Optional[ResourceARN] = Optional.Absent,
    roleARNUpdate: Optional[RoleARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.LambdaOutputUpdate = {
    import LambdaOutputUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.LambdaOutputUpdate
      .builder()
      .optionallyWith(
        resourceARNUpdate.map(value =>
          ResourceARN.unwrap(value): java.lang.String
        )
      )(_.resourceARNUpdate)
      .optionallyWith(
        roleARNUpdate.map(value => RoleARN.unwrap(value): java.lang.String)
      )(_.roleARNUpdate)
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalytics.model.LambdaOutputUpdate.ReadOnly =
    zio.aws.kinesisanalytics.model.LambdaOutputUpdate.wrap(buildAwsValue())
}
object LambdaOutputUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.LambdaOutputUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.LambdaOutputUpdate =
      zio.aws.kinesisanalytics.model.LambdaOutputUpdate(
        resourceARNUpdate.map(value => value),
        roleARNUpdate.map(value => value)
      )
    def resourceARNUpdate: Optional[ResourceARN]
    def roleARNUpdate: Optional[RoleARN]
    def getResourceARNUpdate: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("resourceARNUpdate", resourceARNUpdate)
    def getRoleARNUpdate: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("roleARNUpdate", roleARNUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.LambdaOutputUpdate
  ) extends zio.aws.kinesisanalytics.model.LambdaOutputUpdate.ReadOnly {
    override val resourceARNUpdate: Optional[ResourceARN] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceARNUpdate())
        .map(value =>
          zio.aws.kinesisanalytics.model.primitives.ResourceARN(value)
        )
    override val roleARNUpdate: Optional[RoleARN] = zio.aws.core.internal
      .optionalFromNullable(impl.roleARNUpdate())
      .map(value => zio.aws.kinesisanalytics.model.primitives.RoleARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.LambdaOutputUpdate
  ): zio.aws.kinesisanalytics.model.LambdaOutputUpdate.ReadOnly = new Wrapper(
    impl
  )
}
