package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.{
  RecordColumnSqlType,
  RecordColumnMapping,
  RecordColumnName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RecordColumn(
    name: RecordColumnName,
    mapping: Option[RecordColumnMapping] = None,
    sqlType: RecordColumnSqlType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.RecordColumn = {
    import RecordColumn.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.RecordColumn
      .builder()
      .name(RecordColumnName.unwrap(name): java.lang.String)
      .optionallyWith(
        mapping.map(value =>
          RecordColumnMapping.unwrap(value): java.lang.String
        )
      )(_.mapping)
      .sqlType(RecordColumnSqlType.unwrap(sqlType): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalytics.model.RecordColumn.ReadOnly =
    zio.aws.kinesisanalytics.model.RecordColumn.wrap(buildAwsValue())
}
object RecordColumn {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.RecordColumn
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.RecordColumn =
      zio.aws.kinesisanalytics.model
        .RecordColumn(name, mapping.map(value => value), sqlType)
    def name: RecordColumnName
    def mapping: Option[RecordColumnMapping]
    def sqlType: RecordColumnSqlType
    def getName: ZIO[Any, Nothing, RecordColumnName] = ZIO.succeed(name)
    def getMapping: ZIO[Any, AwsError, RecordColumnMapping] =
      AwsError.unwrapOptionField("mapping", mapping)
    def getSqlType: ZIO[Any, Nothing, RecordColumnSqlType] =
      ZIO.succeed(sqlType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.RecordColumn
  ) extends zio.aws.kinesisanalytics.model.RecordColumn.ReadOnly {
    override val name: RecordColumnName =
      zio.aws.kinesisanalytics.model.primitives.RecordColumnName(impl.name())
    override val mapping: Option[RecordColumnMapping] = scala
      .Option(impl.mapping())
      .map(value =>
        zio.aws.kinesisanalytics.model.primitives.RecordColumnMapping(value)
      )
    override val sqlType: RecordColumnSqlType =
      zio.aws.kinesisanalytics.model.primitives
        .RecordColumnSqlType(impl.sqlType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.RecordColumn
  ): zio.aws.kinesisanalytics.model.RecordColumn.ReadOnly = new Wrapper(impl)
}
