package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.{InAppTableName, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ReferenceDataSourceUpdate(
    referenceId: Id,
    tableNameUpdate: Option[InAppTableName] = None,
    s3ReferenceDataSourceUpdate: Option[
      zio.aws.kinesisanalytics.model.S3ReferenceDataSourceUpdate
    ] = None,
    referenceSchemaUpdate: Option[zio.aws.kinesisanalytics.model.SourceSchema] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSourceUpdate = {
    import ReferenceDataSourceUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSourceUpdate
      .builder()
      .referenceId(Id.unwrap(referenceId): java.lang.String)
      .optionallyWith(
        tableNameUpdate.map(value =>
          InAppTableName.unwrap(value): java.lang.String
        )
      )(_.tableNameUpdate)
      .optionallyWith(
        s3ReferenceDataSourceUpdate.map(value => value.buildAwsValue())
      )(_.s3ReferenceDataSourceUpdate)
      .optionallyWith(
        referenceSchemaUpdate.map(value => value.buildAwsValue())
      )(_.referenceSchemaUpdate)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalytics.model.ReferenceDataSourceUpdate.ReadOnly =
    zio.aws.kinesisanalytics.model.ReferenceDataSourceUpdate
      .wrap(buildAwsValue())
}
object ReferenceDataSourceUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSourceUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.ReferenceDataSourceUpdate =
      zio.aws.kinesisanalytics.model.ReferenceDataSourceUpdate(
        referenceId,
        tableNameUpdate.map(value => value),
        s3ReferenceDataSourceUpdate.map(value => value.asEditable),
        referenceSchemaUpdate.map(value => value.asEditable)
      )
    def referenceId: Id
    def tableNameUpdate: Option[InAppTableName]
    def s3ReferenceDataSourceUpdate: Option[
      zio.aws.kinesisanalytics.model.S3ReferenceDataSourceUpdate.ReadOnly
    ]
    def referenceSchemaUpdate
        : Option[zio.aws.kinesisanalytics.model.SourceSchema.ReadOnly]
    def getReferenceId: ZIO[Any, Nothing, Id] = ZIO.succeed(referenceId)
    def getTableNameUpdate: ZIO[Any, AwsError, InAppTableName] =
      AwsError.unwrapOptionField("tableNameUpdate", tableNameUpdate)
    def getS3ReferenceDataSourceUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.S3ReferenceDataSourceUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "s3ReferenceDataSourceUpdate",
      s3ReferenceDataSourceUpdate
    )
    def getReferenceSchemaUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.SourceSchema.ReadOnly
    ] =
      AwsError.unwrapOptionField("referenceSchemaUpdate", referenceSchemaUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSourceUpdate
  ) extends zio.aws.kinesisanalytics.model.ReferenceDataSourceUpdate.ReadOnly {
    override val referenceId: Id =
      zio.aws.kinesisanalytics.model.primitives.Id(impl.referenceId())
    override val tableNameUpdate: Option[InAppTableName] = scala
      .Option(impl.tableNameUpdate())
      .map(value =>
        zio.aws.kinesisanalytics.model.primitives.InAppTableName(value)
      )
    override val s3ReferenceDataSourceUpdate: Option[
      zio.aws.kinesisanalytics.model.S3ReferenceDataSourceUpdate.ReadOnly
    ] = scala
      .Option(impl.s3ReferenceDataSourceUpdate())
      .map(value =>
        zio.aws.kinesisanalytics.model.S3ReferenceDataSourceUpdate.wrap(value)
      )
    override val referenceSchemaUpdate
        : Option[zio.aws.kinesisanalytics.model.SourceSchema.ReadOnly] = scala
      .Option(impl.referenceSchemaUpdate())
      .map(value => zio.aws.kinesisanalytics.model.SourceSchema.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSourceUpdate
  ): zio.aws.kinesisanalytics.model.ReferenceDataSourceUpdate.ReadOnly =
    new Wrapper(impl)
}
