package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.{
  ApplicationCode,
  ApplicationName,
  Timestamp,
  ApplicationVersionId,
  ResourceARN,
  ApplicationDescription
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ApplicationDetail(
    applicationName: ApplicationName,
    applicationDescription: Option[ApplicationDescription] = None,
    applicationARN: ResourceARN,
    applicationStatus: zio.aws.kinesisanalytics.model.ApplicationStatus,
    createTimestamp: Option[Timestamp] = None,
    lastUpdateTimestamp: Option[Timestamp] = None,
    inputDescriptions: Option[
      Iterable[zio.aws.kinesisanalytics.model.InputDescription]
    ] = None,
    outputDescriptions: Option[
      Iterable[zio.aws.kinesisanalytics.model.OutputDescription]
    ] = None,
    referenceDataSourceDescriptions: Option[
      Iterable[zio.aws.kinesisanalytics.model.ReferenceDataSourceDescription]
    ] = None,
    cloudWatchLoggingOptionDescriptions: Option[Iterable[
      zio.aws.kinesisanalytics.model.CloudWatchLoggingOptionDescription
    ]] = None,
    applicationCode: Option[ApplicationCode] = None,
    applicationVersionId: ApplicationVersionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.ApplicationDetail = {
    import ApplicationDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.ApplicationDetail
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .optionallyWith(
        applicationDescription.map(value =>
          ApplicationDescription.unwrap(value): java.lang.String
        )
      )(_.applicationDescription)
      .applicationARN(ResourceARN.unwrap(applicationARN): java.lang.String)
      .applicationStatus(applicationStatus.unwrap)
      .optionallyWith(
        createTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createTimestamp)
      .optionallyWith(
        lastUpdateTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdateTimestamp)
      .optionallyWith(
        inputDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inputDescriptions)
      .optionallyWith(
        outputDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.outputDescriptions)
      .optionallyWith(
        referenceDataSourceDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.referenceDataSourceDescriptions)
      .optionallyWith(
        cloudWatchLoggingOptionDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cloudWatchLoggingOptionDescriptions)
      .optionallyWith(
        applicationCode.map(value =>
          ApplicationCode.unwrap(value): java.lang.String
        )
      )(_.applicationCode)
      .applicationVersionId(
        ApplicationVersionId.unwrap(applicationVersionId): java.lang.Long
      )
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalytics.model.ApplicationDetail.ReadOnly =
    zio.aws.kinesisanalytics.model.ApplicationDetail.wrap(buildAwsValue())
}
object ApplicationDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.ApplicationDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.ApplicationDetail =
      zio.aws.kinesisanalytics.model.ApplicationDetail(
        applicationName,
        applicationDescription.map(value => value),
        applicationARN,
        applicationStatus,
        createTimestamp.map(value => value),
        lastUpdateTimestamp.map(value => value),
        inputDescriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        outputDescriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        referenceDataSourceDescriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cloudWatchLoggingOptionDescriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        applicationCode.map(value => value),
        applicationVersionId
      )
    def applicationName: ApplicationName
    def applicationDescription: Option[ApplicationDescription]
    def applicationARN: ResourceARN
    def applicationStatus: zio.aws.kinesisanalytics.model.ApplicationStatus
    def createTimestamp: Option[Timestamp]
    def lastUpdateTimestamp: Option[Timestamp]
    def inputDescriptions
        : Option[List[zio.aws.kinesisanalytics.model.InputDescription.ReadOnly]]
    def outputDescriptions: Option[
      List[zio.aws.kinesisanalytics.model.OutputDescription.ReadOnly]
    ]
    def referenceDataSourceDescriptions: Option[List[
      zio.aws.kinesisanalytics.model.ReferenceDataSourceDescription.ReadOnly
    ]]
    def cloudWatchLoggingOptionDescriptions: Option[List[
      zio.aws.kinesisanalytics.model.CloudWatchLoggingOptionDescription.ReadOnly
    ]]
    def applicationCode: Option[ApplicationCode]
    def applicationVersionId: ApplicationVersionId
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getApplicationDescription: ZIO[Any, AwsError, ApplicationDescription] =
      AwsError.unwrapOptionField(
        "applicationDescription",
        applicationDescription
      )
    def getApplicationARN: ZIO[Any, Nothing, ResourceARN] =
      ZIO.succeed(applicationARN)
    def getApplicationStatus
        : ZIO[Any, Nothing, zio.aws.kinesisanalytics.model.ApplicationStatus] =
      ZIO.succeed(applicationStatus)
    def getCreateTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createTimestamp", createTimestamp)
    def getLastUpdateTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdateTimestamp", lastUpdateTimestamp)
    def getInputDescriptions: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalytics.model.InputDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("inputDescriptions", inputDescriptions)
    def getOutputDescriptions: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalytics.model.OutputDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("outputDescriptions", outputDescriptions)
    def getReferenceDataSourceDescriptions: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalytics.model.ReferenceDataSourceDescription.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "referenceDataSourceDescriptions",
      referenceDataSourceDescriptions
    )
    def getCloudWatchLoggingOptionDescriptions: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalytics.model.CloudWatchLoggingOptionDescription.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "cloudWatchLoggingOptionDescriptions",
      cloudWatchLoggingOptionDescriptions
    )
    def getApplicationCode: ZIO[Any, AwsError, ApplicationCode] =
      AwsError.unwrapOptionField("applicationCode", applicationCode)
    def getApplicationVersionId: ZIO[Any, Nothing, ApplicationVersionId] =
      ZIO.succeed(applicationVersionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.ApplicationDetail
  ) extends zio.aws.kinesisanalytics.model.ApplicationDetail.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.kinesisanalytics.model.primitives
        .ApplicationName(impl.applicationName())
    override val applicationDescription: Option[ApplicationDescription] = scala
      .Option(impl.applicationDescription())
      .map(value =>
        zio.aws.kinesisanalytics.model.primitives.ApplicationDescription(value)
      )
    override val applicationARN: ResourceARN =
      zio.aws.kinesisanalytics.model.primitives
        .ResourceARN(impl.applicationARN())
    override val applicationStatus
        : zio.aws.kinesisanalytics.model.ApplicationStatus =
      zio.aws.kinesisanalytics.model.ApplicationStatus
        .wrap(impl.applicationStatus())
    override val createTimestamp: Option[Timestamp] = scala
      .Option(impl.createTimestamp())
      .map(value => zio.aws.kinesisanalytics.model.primitives.Timestamp(value))
    override val lastUpdateTimestamp: Option[Timestamp] = scala
      .Option(impl.lastUpdateTimestamp())
      .map(value => zio.aws.kinesisanalytics.model.primitives.Timestamp(value))
    override val inputDescriptions: Option[
      List[zio.aws.kinesisanalytics.model.InputDescription.ReadOnly]
    ] = scala
      .Option(impl.inputDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalytics.model.InputDescription.wrap(item)
        }.toList
      )
    override val outputDescriptions: Option[
      List[zio.aws.kinesisanalytics.model.OutputDescription.ReadOnly]
    ] = scala
      .Option(impl.outputDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalytics.model.OutputDescription.wrap(item)
        }.toList
      )
    override val referenceDataSourceDescriptions: Option[List[
      zio.aws.kinesisanalytics.model.ReferenceDataSourceDescription.ReadOnly
    ]] = scala
      .Option(impl.referenceDataSourceDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalytics.model.ReferenceDataSourceDescription
            .wrap(item)
        }.toList
      )
    override val cloudWatchLoggingOptionDescriptions: Option[List[
      zio.aws.kinesisanalytics.model.CloudWatchLoggingOptionDescription.ReadOnly
    ]] = scala
      .Option(impl.cloudWatchLoggingOptionDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalytics.model.CloudWatchLoggingOptionDescription
            .wrap(item)
        }.toList
      )
    override val applicationCode: Option[ApplicationCode] = scala
      .Option(impl.applicationCode())
      .map(value =>
        zio.aws.kinesisanalytics.model.primitives.ApplicationCode(value)
      )
    override val applicationVersionId: ApplicationVersionId =
      zio.aws.kinesisanalytics.model.primitives
        .ApplicationVersionId(impl.applicationVersionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.ApplicationDetail
  ): zio.aws.kinesisanalytics.model.ApplicationDetail.ReadOnly = new Wrapper(
    impl
  )
}
