package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.{
  ApplicationVersionId,
  ApplicationName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AddApplicationInputRequest(
    applicationName: ApplicationName,
    currentApplicationVersionId: ApplicationVersionId,
    input: zio.aws.kinesisanalytics.model.Input
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationInputRequest = {
    import AddApplicationInputRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationInputRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .currentApplicationVersionId(
        ApplicationVersionId.unwrap(currentApplicationVersionId): java.lang.Long
      )
      .input(input.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalytics.model.AddApplicationInputRequest.ReadOnly =
    zio.aws.kinesisanalytics.model.AddApplicationInputRequest
      .wrap(buildAwsValue())
}
object AddApplicationInputRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationInputRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.AddApplicationInputRequest =
      zio.aws.kinesisanalytics.model.AddApplicationInputRequest(
        applicationName,
        currentApplicationVersionId,
        input.asEditable
      )
    def applicationName: ApplicationName
    def currentApplicationVersionId: ApplicationVersionId
    def input: zio.aws.kinesisanalytics.model.Input.ReadOnly
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getCurrentApplicationVersionId
        : ZIO[Any, Nothing, ApplicationVersionId] =
      ZIO.succeed(currentApplicationVersionId)
    def getInput
        : ZIO[Any, Nothing, zio.aws.kinesisanalytics.model.Input.ReadOnly] =
      ZIO.succeed(input)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationInputRequest
  ) extends zio.aws.kinesisanalytics.model.AddApplicationInputRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.kinesisanalytics.model.primitives
        .ApplicationName(impl.applicationName())
    override val currentApplicationVersionId: ApplicationVersionId =
      zio.aws.kinesisanalytics.model.primitives
        .ApplicationVersionId(impl.currentApplicationVersionId())
    override val input: zio.aws.kinesisanalytics.model.Input.ReadOnly =
      zio.aws.kinesisanalytics.model.Input.wrap(impl.input())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationInputRequest
  ): zio.aws.kinesisanalytics.model.AddApplicationInputRequest.ReadOnly =
    new Wrapper(impl)
}
