package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.{FileKey, BucketARN, RoleARN}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class S3Configuration(
    roleARN: RoleARN,
    bucketARN: BucketARN,
    fileKey: FileKey
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.S3Configuration = {
    import S3Configuration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.S3Configuration
      .builder()
      .roleARN(RoleARN.unwrap(roleARN): java.lang.String)
      .bucketARN(BucketARN.unwrap(bucketARN): java.lang.String)
      .fileKey(FileKey.unwrap(fileKey): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalytics.model.S3Configuration.ReadOnly =
    zio.aws.kinesisanalytics.model.S3Configuration.wrap(buildAwsValue())
}
object S3Configuration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.S3Configuration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.S3Configuration =
      zio.aws.kinesisanalytics.model
        .S3Configuration(roleARN, bucketARN, fileKey)
    def roleARN: RoleARN
    def bucketARN: BucketARN
    def fileKey: FileKey
    def getRoleARN: ZIO[Any, Nothing, RoleARN] = ZIO.succeed(roleARN)
    def getBucketARN: ZIO[Any, Nothing, BucketARN] = ZIO.succeed(bucketARN)
    def getFileKey: ZIO[Any, Nothing, FileKey] = ZIO.succeed(fileKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.S3Configuration
  ) extends zio.aws.kinesisanalytics.model.S3Configuration.ReadOnly {
    override val roleARN: RoleARN =
      zio.aws.kinesisanalytics.model.primitives.RoleARN(impl.roleARN())
    override val bucketARN: BucketARN =
      zio.aws.kinesisanalytics.model.primitives.BucketARN(impl.bucketARN())
    override val fileKey: FileKey =
      zio.aws.kinesisanalytics.model.primitives.FileKey(impl.fileKey())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.S3Configuration
  ): zio.aws.kinesisanalytics.model.S3Configuration.ReadOnly = new Wrapper(impl)
}
