package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.{
  ApplicationCode,
  ApplicationDescription,
  ApplicationName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateApplicationRequest(
    applicationName: ApplicationName,
    applicationDescription: Option[ApplicationDescription] = None,
    inputs: Option[Iterable[zio.aws.kinesisanalytics.model.Input]] = None,
    outputs: Option[Iterable[zio.aws.kinesisanalytics.model.Output]] = None,
    cloudWatchLoggingOptions: Option[
      Iterable[zio.aws.kinesisanalytics.model.CloudWatchLoggingOption]
    ] = None,
    applicationCode: Option[ApplicationCode] = None,
    tags: Option[Iterable[zio.aws.kinesisanalytics.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.CreateApplicationRequest = {
    import CreateApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.CreateApplicationRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .optionallyWith(
        applicationDescription.map(value =>
          ApplicationDescription.unwrap(value): java.lang.String
        )
      )(_.applicationDescription)
      .optionallyWith(
        inputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inputs)
      .optionallyWith(
        outputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.outputs)
      .optionallyWith(
        cloudWatchLoggingOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cloudWatchLoggingOptions)
      .optionallyWith(
        applicationCode.map(value =>
          ApplicationCode.unwrap(value): java.lang.String
        )
      )(_.applicationCode)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalytics.model.CreateApplicationRequest.ReadOnly =
    zio.aws.kinesisanalytics.model.CreateApplicationRequest
      .wrap(buildAwsValue())
}
object CreateApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.CreateApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.CreateApplicationRequest =
      zio.aws.kinesisanalytics.model.CreateApplicationRequest(
        applicationName,
        applicationDescription.map(value => value),
        inputs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        outputs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cloudWatchLoggingOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        applicationCode.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def applicationName: ApplicationName
    def applicationDescription: Option[ApplicationDescription]
    def inputs: Option[List[zio.aws.kinesisanalytics.model.Input.ReadOnly]]
    def outputs: Option[List[zio.aws.kinesisanalytics.model.Output.ReadOnly]]
    def cloudWatchLoggingOptions: Option[
      List[zio.aws.kinesisanalytics.model.CloudWatchLoggingOption.ReadOnly]
    ]
    def applicationCode: Option[ApplicationCode]
    def tags: Option[List[zio.aws.kinesisanalytics.model.Tag.ReadOnly]]
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getApplicationDescription: ZIO[Any, AwsError, ApplicationDescription] =
      AwsError.unwrapOptionField(
        "applicationDescription",
        applicationDescription
      )
    def getInputs: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalytics.model.Input.ReadOnly
    ]] = AwsError.unwrapOptionField("inputs", inputs)
    def getOutputs: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalytics.model.Output.ReadOnly
    ]] = AwsError.unwrapOptionField("outputs", outputs)
    def getCloudWatchLoggingOptions: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalytics.model.CloudWatchLoggingOption.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "cloudWatchLoggingOptions",
      cloudWatchLoggingOptions
    )
    def getApplicationCode: ZIO[Any, AwsError, ApplicationCode] =
      AwsError.unwrapOptionField("applicationCode", applicationCode)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalytics.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.CreateApplicationRequest
  ) extends zio.aws.kinesisanalytics.model.CreateApplicationRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.kinesisanalytics.model.primitives
        .ApplicationName(impl.applicationName())
    override val applicationDescription: Option[ApplicationDescription] = scala
      .Option(impl.applicationDescription())
      .map(value =>
        zio.aws.kinesisanalytics.model.primitives.ApplicationDescription(value)
      )
    override val inputs
        : Option[List[zio.aws.kinesisanalytics.model.Input.ReadOnly]] = scala
      .Option(impl.inputs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalytics.model.Input.wrap(item)
        }.toList
      )
    override val outputs
        : Option[List[zio.aws.kinesisanalytics.model.Output.ReadOnly]] = scala
      .Option(impl.outputs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalytics.model.Output.wrap(item)
        }.toList
      )
    override val cloudWatchLoggingOptions: Option[
      List[zio.aws.kinesisanalytics.model.CloudWatchLoggingOption.ReadOnly]
    ] = scala
      .Option(impl.cloudWatchLoggingOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalytics.model.CloudWatchLoggingOption.wrap(item)
        }.toList
      )
    override val applicationCode: Option[ApplicationCode] = scala
      .Option(impl.applicationCode())
      .map(value =>
        zio.aws.kinesisanalytics.model.primitives.ApplicationCode(value)
      )
    override val tags
        : Option[List[zio.aws.kinesisanalytics.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalytics.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.CreateApplicationRequest
  ): zio.aws.kinesisanalytics.model.CreateApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
