package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.InAppStreamName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Output(
    name: InAppStreamName,
    kinesisStreamsOutput: Option[
      zio.aws.kinesisanalytics.model.KinesisStreamsOutput
    ] = None,
    kinesisFirehoseOutput: Option[
      zio.aws.kinesisanalytics.model.KinesisFirehoseOutput
    ] = None,
    lambdaOutput: Option[zio.aws.kinesisanalytics.model.LambdaOutput] = None,
    destinationSchema: zio.aws.kinesisanalytics.model.DestinationSchema
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.Output = {
    import Output.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.Output
      .builder()
      .name(InAppStreamName.unwrap(name): java.lang.String)
      .optionallyWith(kinesisStreamsOutput.map(value => value.buildAwsValue()))(
        _.kinesisStreamsOutput
      )
      .optionallyWith(
        kinesisFirehoseOutput.map(value => value.buildAwsValue())
      )(_.kinesisFirehoseOutput)
      .optionallyWith(lambdaOutput.map(value => value.buildAwsValue()))(
        _.lambdaOutput
      )
      .destinationSchema(destinationSchema.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalytics.model.Output.ReadOnly =
    zio.aws.kinesisanalytics.model.Output.wrap(buildAwsValue())
}
object Output {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.Output
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.Output =
      zio.aws.kinesisanalytics.model.Output(
        name,
        kinesisStreamsOutput.map(value => value.asEditable),
        kinesisFirehoseOutput.map(value => value.asEditable),
        lambdaOutput.map(value => value.asEditable),
        destinationSchema.asEditable
      )
    def name: InAppStreamName
    def kinesisStreamsOutput
        : Option[zio.aws.kinesisanalytics.model.KinesisStreamsOutput.ReadOnly]
    def kinesisFirehoseOutput
        : Option[zio.aws.kinesisanalytics.model.KinesisFirehoseOutput.ReadOnly]
    def lambdaOutput
        : Option[zio.aws.kinesisanalytics.model.LambdaOutput.ReadOnly]
    def destinationSchema
        : zio.aws.kinesisanalytics.model.DestinationSchema.ReadOnly
    def getName: ZIO[Any, Nothing, InAppStreamName] = ZIO.succeed(name)
    def getKinesisStreamsOutput: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.KinesisStreamsOutput.ReadOnly
    ] = AwsError.unwrapOptionField("kinesisStreamsOutput", kinesisStreamsOutput)
    def getKinesisFirehoseOutput: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.KinesisFirehoseOutput.ReadOnly
    ] =
      AwsError.unwrapOptionField("kinesisFirehoseOutput", kinesisFirehoseOutput)
    def getLambdaOutput: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.LambdaOutput.ReadOnly
    ] = AwsError.unwrapOptionField("lambdaOutput", lambdaOutput)
    def getDestinationSchema: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisanalytics.model.DestinationSchema.ReadOnly
    ] = ZIO.succeed(destinationSchema)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.Output
  ) extends zio.aws.kinesisanalytics.model.Output.ReadOnly {
    override val name: InAppStreamName =
      zio.aws.kinesisanalytics.model.primitives.InAppStreamName(impl.name())
    override val kinesisStreamsOutput
        : Option[zio.aws.kinesisanalytics.model.KinesisStreamsOutput.ReadOnly] =
      scala
        .Option(impl.kinesisStreamsOutput())
        .map(value =>
          zio.aws.kinesisanalytics.model.KinesisStreamsOutput.wrap(value)
        )
    override val kinesisFirehoseOutput: Option[
      zio.aws.kinesisanalytics.model.KinesisFirehoseOutput.ReadOnly
    ] = scala
      .Option(impl.kinesisFirehoseOutput())
      .map(value =>
        zio.aws.kinesisanalytics.model.KinesisFirehoseOutput.wrap(value)
      )
    override val lambdaOutput
        : Option[zio.aws.kinesisanalytics.model.LambdaOutput.ReadOnly] = scala
      .Option(impl.lambdaOutput())
      .map(value => zio.aws.kinesisanalytics.model.LambdaOutput.wrap(value))
    override val destinationSchema
        : zio.aws.kinesisanalytics.model.DestinationSchema.ReadOnly =
      zio.aws.kinesisanalytics.model.DestinationSchema
        .wrap(impl.destinationSchema())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.Output
  ): zio.aws.kinesisanalytics.model.Output.ReadOnly = new Wrapper(impl)
}
