package zio.aws.kinesisanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InputProcessingConfigurationDescription(
    inputLambdaProcessorDescription: Option[
      zio.aws.kinesisanalytics.model.InputLambdaProcessorDescription
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.InputProcessingConfigurationDescription = {
    import InputProcessingConfigurationDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.InputProcessingConfigurationDescription
      .builder()
      .optionallyWith(
        inputLambdaProcessorDescription.map(value => value.buildAwsValue())
      )(_.inputLambdaProcessorDescription)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalytics.model.InputProcessingConfigurationDescription.ReadOnly =
    zio.aws.kinesisanalytics.model.InputProcessingConfigurationDescription
      .wrap(buildAwsValue())
}
object InputProcessingConfigurationDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.InputProcessingConfigurationDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalytics.model.InputProcessingConfigurationDescription =
      zio.aws.kinesisanalytics.model.InputProcessingConfigurationDescription(
        inputLambdaProcessorDescription.map(value => value.asEditable)
      )
    def inputLambdaProcessorDescription: Option[
      zio.aws.kinesisanalytics.model.InputLambdaProcessorDescription.ReadOnly
    ]
    def getInputLambdaProcessorDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.InputLambdaProcessorDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inputLambdaProcessorDescription",
      inputLambdaProcessorDescription
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.InputProcessingConfigurationDescription
  ) extends zio.aws.kinesisanalytics.model.InputProcessingConfigurationDescription.ReadOnly {
    override val inputLambdaProcessorDescription: Option[
      zio.aws.kinesisanalytics.model.InputLambdaProcessorDescription.ReadOnly
    ] = scala
      .Option(impl.inputLambdaProcessorDescription())
      .map(value =>
        zio.aws.kinesisanalytics.model.InputLambdaProcessorDescription
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.InputProcessingConfigurationDescription
  ): zio.aws.kinesisanalytics.model.InputProcessingConfigurationDescription.ReadOnly =
    new Wrapper(impl)
}
