package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.InAppStreamName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Input(
    namePrefix: InAppStreamName,
    inputProcessingConfiguration: Option[
      zio.aws.kinesisanalytics.model.InputProcessingConfiguration
    ] = None,
    kinesisStreamsInput: Option[
      zio.aws.kinesisanalytics.model.KinesisStreamsInput
    ] = None,
    kinesisFirehoseInput: Option[
      zio.aws.kinesisanalytics.model.KinesisFirehoseInput
    ] = None,
    inputParallelism: Option[zio.aws.kinesisanalytics.model.InputParallelism] =
      None,
    inputSchema: zio.aws.kinesisanalytics.model.SourceSchema
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.Input = {
    import Input.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.Input
      .builder()
      .namePrefix(InAppStreamName.unwrap(namePrefix): java.lang.String)
      .optionallyWith(
        inputProcessingConfiguration.map(value => value.buildAwsValue())
      )(_.inputProcessingConfiguration)
      .optionallyWith(kinesisStreamsInput.map(value => value.buildAwsValue()))(
        _.kinesisStreamsInput
      )
      .optionallyWith(kinesisFirehoseInput.map(value => value.buildAwsValue()))(
        _.kinesisFirehoseInput
      )
      .optionallyWith(inputParallelism.map(value => value.buildAwsValue()))(
        _.inputParallelism
      )
      .inputSchema(inputSchema.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalytics.model.Input.ReadOnly =
    zio.aws.kinesisanalytics.model.Input.wrap(buildAwsValue())
}
object Input {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.Input
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.Input =
      zio.aws.kinesisanalytics.model.Input(
        namePrefix,
        inputProcessingConfiguration.map(value => value.asEditable),
        kinesisStreamsInput.map(value => value.asEditable),
        kinesisFirehoseInput.map(value => value.asEditable),
        inputParallelism.map(value => value.asEditable),
        inputSchema.asEditable
      )
    def namePrefix: InAppStreamName
    def inputProcessingConfiguration: Option[
      zio.aws.kinesisanalytics.model.InputProcessingConfiguration.ReadOnly
    ]
    def kinesisStreamsInput
        : Option[zio.aws.kinesisanalytics.model.KinesisStreamsInput.ReadOnly]
    def kinesisFirehoseInput
        : Option[zio.aws.kinesisanalytics.model.KinesisFirehoseInput.ReadOnly]
    def inputParallelism
        : Option[zio.aws.kinesisanalytics.model.InputParallelism.ReadOnly]
    def inputSchema: zio.aws.kinesisanalytics.model.SourceSchema.ReadOnly
    def getNamePrefix: ZIO[Any, Nothing, InAppStreamName] =
      ZIO.succeed(namePrefix)
    def getInputProcessingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.InputProcessingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inputProcessingConfiguration",
      inputProcessingConfiguration
    )
    def getKinesisStreamsInput: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.KinesisStreamsInput.ReadOnly
    ] = AwsError.unwrapOptionField("kinesisStreamsInput", kinesisStreamsInput)
    def getKinesisFirehoseInput: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.KinesisFirehoseInput.ReadOnly
    ] = AwsError.unwrapOptionField("kinesisFirehoseInput", kinesisFirehoseInput)
    def getInputParallelism: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.InputParallelism.ReadOnly
    ] = AwsError.unwrapOptionField("inputParallelism", inputParallelism)
    def getInputSchema: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisanalytics.model.SourceSchema.ReadOnly
    ] = ZIO.succeed(inputSchema)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.Input
  ) extends zio.aws.kinesisanalytics.model.Input.ReadOnly {
    override val namePrefix: InAppStreamName =
      zio.aws.kinesisanalytics.model.primitives
        .InAppStreamName(impl.namePrefix())
    override val inputProcessingConfiguration: Option[
      zio.aws.kinesisanalytics.model.InputProcessingConfiguration.ReadOnly
    ] = scala
      .Option(impl.inputProcessingConfiguration())
      .map(value =>
        zio.aws.kinesisanalytics.model.InputProcessingConfiguration.wrap(value)
      )
    override val kinesisStreamsInput
        : Option[zio.aws.kinesisanalytics.model.KinesisStreamsInput.ReadOnly] =
      scala
        .Option(impl.kinesisStreamsInput())
        .map(value =>
          zio.aws.kinesisanalytics.model.KinesisStreamsInput.wrap(value)
        )
    override val kinesisFirehoseInput
        : Option[zio.aws.kinesisanalytics.model.KinesisFirehoseInput.ReadOnly] =
      scala
        .Option(impl.kinesisFirehoseInput())
        .map(value =>
          zio.aws.kinesisanalytics.model.KinesisFirehoseInput.wrap(value)
        )
    override val inputParallelism
        : Option[zio.aws.kinesisanalytics.model.InputParallelism.ReadOnly] =
      scala
        .Option(impl.inputParallelism())
        .map(value =>
          zio.aws.kinesisanalytics.model.InputParallelism.wrap(value)
        )
    override val inputSchema
        : zio.aws.kinesisanalytics.model.SourceSchema.ReadOnly =
      zio.aws.kinesisanalytics.model.SourceSchema.wrap(impl.inputSchema())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.Input
  ): zio.aws.kinesisanalytics.model.Input.ReadOnly = new Wrapper(impl)
}
