package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.{RoleARN, ResourceARN}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DiscoverInputSchemaRequest(
    resourceARN: Option[ResourceARN] = None,
    roleARN: Option[RoleARN] = None,
    inputStartingPositionConfiguration: Option[
      zio.aws.kinesisanalytics.model.InputStartingPositionConfiguration
    ] = None,
    s3Configuration: Option[zio.aws.kinesisanalytics.model.S3Configuration] =
      None,
    inputProcessingConfiguration: Option[
      zio.aws.kinesisanalytics.model.InputProcessingConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.DiscoverInputSchemaRequest = {
    import DiscoverInputSchemaRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.DiscoverInputSchemaRequest
      .builder()
      .optionallyWith(
        resourceARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.resourceARN)
      .optionallyWith(
        roleARN.map(value => RoleARN.unwrap(value): java.lang.String)
      )(_.roleARN)
      .optionallyWith(
        inputStartingPositionConfiguration.map(value => value.buildAwsValue())
      )(_.inputStartingPositionConfiguration)
      .optionallyWith(s3Configuration.map(value => value.buildAwsValue()))(
        _.s3Configuration
      )
      .optionallyWith(
        inputProcessingConfiguration.map(value => value.buildAwsValue())
      )(_.inputProcessingConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalytics.model.DiscoverInputSchemaRequest.ReadOnly =
    zio.aws.kinesisanalytics.model.DiscoverInputSchemaRequest
      .wrap(buildAwsValue())
}
object DiscoverInputSchemaRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.DiscoverInputSchemaRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.DiscoverInputSchemaRequest =
      zio.aws.kinesisanalytics.model.DiscoverInputSchemaRequest(
        resourceARN.map(value => value),
        roleARN.map(value => value),
        inputStartingPositionConfiguration.map(value => value.asEditable),
        s3Configuration.map(value => value.asEditable),
        inputProcessingConfiguration.map(value => value.asEditable)
      )
    def resourceARN: Option[ResourceARN]
    def roleARN: Option[RoleARN]
    def inputStartingPositionConfiguration: Option[
      zio.aws.kinesisanalytics.model.InputStartingPositionConfiguration.ReadOnly
    ]
    def s3Configuration
        : Option[zio.aws.kinesisanalytics.model.S3Configuration.ReadOnly]
    def inputProcessingConfiguration: Option[
      zio.aws.kinesisanalytics.model.InputProcessingConfiguration.ReadOnly
    ]
    def getResourceARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("resourceARN", resourceARN)
    def getRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("roleARN", roleARN)
    def getInputStartingPositionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.InputStartingPositionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inputStartingPositionConfiguration",
      inputStartingPositionConfiguration
    )
    def getS3Configuration: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.S3Configuration.ReadOnly
    ] = AwsError.unwrapOptionField("s3Configuration", s3Configuration)
    def getInputProcessingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.InputProcessingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inputProcessingConfiguration",
      inputProcessingConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.DiscoverInputSchemaRequest
  ) extends zio.aws.kinesisanalytics.model.DiscoverInputSchemaRequest.ReadOnly {
    override val resourceARN: Option[ResourceARN] = scala
      .Option(impl.resourceARN())
      .map(value =>
        zio.aws.kinesisanalytics.model.primitives.ResourceARN(value)
      )
    override val roleARN: Option[RoleARN] = scala
      .Option(impl.roleARN())
      .map(value => zio.aws.kinesisanalytics.model.primitives.RoleARN(value))
    override val inputStartingPositionConfiguration: Option[
      zio.aws.kinesisanalytics.model.InputStartingPositionConfiguration.ReadOnly
    ] = scala
      .Option(impl.inputStartingPositionConfiguration())
      .map(value =>
        zio.aws.kinesisanalytics.model.InputStartingPositionConfiguration
          .wrap(value)
      )
    override val s3Configuration
        : Option[zio.aws.kinesisanalytics.model.S3Configuration.ReadOnly] =
      scala
        .Option(impl.s3Configuration())
        .map(value =>
          zio.aws.kinesisanalytics.model.S3Configuration.wrap(value)
        )
    override val inputProcessingConfiguration: Option[
      zio.aws.kinesisanalytics.model.InputProcessingConfiguration.ReadOnly
    ] = scala
      .Option(impl.inputProcessingConfiguration())
      .map(value =>
        zio.aws.kinesisanalytics.model.InputProcessingConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.DiscoverInputSchemaRequest
  ): zio.aws.kinesisanalytics.model.DiscoverInputSchemaRequest.ReadOnly =
    new Wrapper(impl)
}
