package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.BooleanObject
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ListApplicationsResponse(
    applicationSummaries: Iterable[
      zio.aws.kinesisanalytics.model.ApplicationSummary
    ],
    hasMoreApplications: BooleanObject
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.ListApplicationsResponse = {
    import ListApplicationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.ListApplicationsResponse
      .builder()
      .applicationSummaries(applicationSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .hasMoreApplications(
        BooleanObject.unwrap(hasMoreApplications): java.lang.Boolean
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalytics.model.ListApplicationsResponse.ReadOnly =
    zio.aws.kinesisanalytics.model.ListApplicationsResponse
      .wrap(buildAwsValue())
}
object ListApplicationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.ListApplicationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.ListApplicationsResponse =
      zio.aws.kinesisanalytics.model.ListApplicationsResponse(
        applicationSummaries.map { item =>
          item.asEditable
        },
        hasMoreApplications
      )
    def applicationSummaries
        : List[zio.aws.kinesisanalytics.model.ApplicationSummary.ReadOnly]
    def hasMoreApplications: BooleanObject
    def getApplicationSummaries: ZIO[Any, Nothing, List[
      zio.aws.kinesisanalytics.model.ApplicationSummary.ReadOnly
    ]] = ZIO.succeed(applicationSummaries)
    def getHasMoreApplications: ZIO[Any, Nothing, BooleanObject] =
      ZIO.succeed(hasMoreApplications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.ListApplicationsResponse
  ) extends zio.aws.kinesisanalytics.model.ListApplicationsResponse.ReadOnly {
    override val applicationSummaries
        : List[zio.aws.kinesisanalytics.model.ApplicationSummary.ReadOnly] =
      impl
        .applicationSummaries()
        .asScala
        .map { item =>
          zio.aws.kinesisanalytics.model.ApplicationSummary.wrap(item)
        }
        .toList
    override val hasMoreApplications: BooleanObject =
      zio.aws.kinesisanalytics.model.primitives
        .BooleanObject(impl.hasMoreApplications())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.ListApplicationsResponse
  ): zio.aws.kinesisanalytics.model.ListApplicationsResponse.ReadOnly =
    new Wrapper(impl)
}
