package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.{RoleARN, FileKey, BucketARN}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class S3ReferenceDataSource(
    bucketARN: BucketARN,
    fileKey: FileKey,
    referenceRoleARN: RoleARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.S3ReferenceDataSource = {
    import S3ReferenceDataSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.S3ReferenceDataSource
      .builder()
      .bucketARN(BucketARN.unwrap(bucketARN): java.lang.String)
      .fileKey(FileKey.unwrap(fileKey): java.lang.String)
      .referenceRoleARN(RoleARN.unwrap(referenceRoleARN): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalytics.model.S3ReferenceDataSource.ReadOnly =
    zio.aws.kinesisanalytics.model.S3ReferenceDataSource.wrap(buildAwsValue())
}
object S3ReferenceDataSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.S3ReferenceDataSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.S3ReferenceDataSource =
      zio.aws.kinesisanalytics.model
        .S3ReferenceDataSource(bucketARN, fileKey, referenceRoleARN)
    def bucketARN: BucketARN
    def fileKey: FileKey
    def referenceRoleARN: RoleARN
    def getBucketARN: ZIO[Any, Nothing, BucketARN] = ZIO.succeed(bucketARN)
    def getFileKey: ZIO[Any, Nothing, FileKey] = ZIO.succeed(fileKey)
    def getReferenceRoleARN: ZIO[Any, Nothing, RoleARN] =
      ZIO.succeed(referenceRoleARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.S3ReferenceDataSource
  ) extends zio.aws.kinesisanalytics.model.S3ReferenceDataSource.ReadOnly {
    override val bucketARN: BucketARN =
      zio.aws.kinesisanalytics.model.primitives.BucketARN(impl.bucketARN())
    override val fileKey: FileKey =
      zio.aws.kinesisanalytics.model.primitives.FileKey(impl.fileKey())
    override val referenceRoleARN: RoleARN =
      zio.aws.kinesisanalytics.model.primitives.RoleARN(impl.referenceRoleARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.S3ReferenceDataSource
  ): zio.aws.kinesisanalytics.model.S3ReferenceDataSource.ReadOnly =
    new Wrapper(impl)
}
