package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.{TagKey, KinesisAnalyticsARN}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UntagResourceRequest(
    resourceARN: KinesisAnalyticsARN,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.UntagResourceRequest
      .builder()
      .resourceARN(KinesisAnalyticsARN.unwrap(resourceARN): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalytics.model.UntagResourceRequest.ReadOnly =
    zio.aws.kinesisanalytics.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.UntagResourceRequest =
      zio.aws.kinesisanalytics.model.UntagResourceRequest(resourceARN, tagKeys)
    def resourceARN: KinesisAnalyticsARN
    def tagKeys: List[TagKey]
    def getResourceARN: ZIO[Any, Nothing, KinesisAnalyticsARN] =
      ZIO.succeed(resourceARN)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.UntagResourceRequest
  ) extends zio.aws.kinesisanalytics.model.UntagResourceRequest.ReadOnly {
    override val resourceARN: KinesisAnalyticsARN =
      zio.aws.kinesisanalytics.model.primitives
        .KinesisAnalyticsARN(impl.resourceARN())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.kinesisanalytics.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.UntagResourceRequest
  ): zio.aws.kinesisanalytics.model.UntagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
