package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.{RoleARN, ResourceARN}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class KinesisStreamsOutputUpdate(
    resourceARNUpdate: Option[ResourceARN] = None,
    roleARNUpdate: Option[RoleARN] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.KinesisStreamsOutputUpdate = {
    import KinesisStreamsOutputUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.KinesisStreamsOutputUpdate
      .builder()
      .optionallyWith(
        resourceARNUpdate.map(value =>
          ResourceARN.unwrap(value): java.lang.String
        )
      )(_.resourceARNUpdate)
      .optionallyWith(
        roleARNUpdate.map(value => RoleARN.unwrap(value): java.lang.String)
      )(_.roleARNUpdate)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalytics.model.KinesisStreamsOutputUpdate.ReadOnly =
    zio.aws.kinesisanalytics.model.KinesisStreamsOutputUpdate
      .wrap(buildAwsValue())
}
object KinesisStreamsOutputUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.KinesisStreamsOutputUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.KinesisStreamsOutputUpdate =
      zio.aws.kinesisanalytics.model.KinesisStreamsOutputUpdate(
        resourceARNUpdate.map(value => value),
        roleARNUpdate.map(value => value)
      )
    def resourceARNUpdate: Option[ResourceARN]
    def roleARNUpdate: Option[RoleARN]
    def getResourceARNUpdate: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("resourceARNUpdate", resourceARNUpdate)
    def getRoleARNUpdate: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("roleARNUpdate", roleARNUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.KinesisStreamsOutputUpdate
  ) extends zio.aws.kinesisanalytics.model.KinesisStreamsOutputUpdate.ReadOnly {
    override val resourceARNUpdate: Option[ResourceARN] = scala
      .Option(impl.resourceARNUpdate())
      .map(value =>
        zio.aws.kinesisanalytics.model.primitives.ResourceARN(value)
      )
    override val roleARNUpdate: Option[RoleARN] = scala
      .Option(impl.roleARNUpdate())
      .map(value => zio.aws.kinesisanalytics.model.primitives.RoleARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.KinesisStreamsOutputUpdate
  ): zio.aws.kinesisanalytics.model.KinesisStreamsOutputUpdate.ReadOnly =
    new Wrapper(impl)
}
