package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.{
  Id,
  ApplicationVersionId,
  ApplicationName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteApplicationReferenceDataSourceRequest(
    applicationName: ApplicationName,
    currentApplicationVersionId: ApplicationVersionId,
    referenceId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationReferenceDataSourceRequest = {
    import DeleteApplicationReferenceDataSourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationReferenceDataSourceRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .currentApplicationVersionId(
        ApplicationVersionId.unwrap(currentApplicationVersionId): java.lang.Long
      )
      .referenceId(Id.unwrap(referenceId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalytics.model.DeleteApplicationReferenceDataSourceRequest.ReadOnly =
    zio.aws.kinesisanalytics.model.DeleteApplicationReferenceDataSourceRequest
      .wrap(buildAwsValue())
}
object DeleteApplicationReferenceDataSourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationReferenceDataSourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalytics.model.DeleteApplicationReferenceDataSourceRequest =
      zio.aws.kinesisanalytics.model
        .DeleteApplicationReferenceDataSourceRequest(
          applicationName,
          currentApplicationVersionId,
          referenceId
        )
    def applicationName: ApplicationName
    def currentApplicationVersionId: ApplicationVersionId
    def referenceId: Id
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getCurrentApplicationVersionId
        : ZIO[Any, Nothing, ApplicationVersionId] =
      ZIO.succeed(currentApplicationVersionId)
    def getReferenceId: ZIO[Any, Nothing, Id] = ZIO.succeed(referenceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationReferenceDataSourceRequest
  ) extends zio.aws.kinesisanalytics.model.DeleteApplicationReferenceDataSourceRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.kinesisanalytics.model.primitives
        .ApplicationName(impl.applicationName())
    override val currentApplicationVersionId: ApplicationVersionId =
      zio.aws.kinesisanalytics.model.primitives
        .ApplicationVersionId(impl.currentApplicationVersionId())
    override val referenceId: Id =
      zio.aws.kinesisanalytics.model.primitives.Id(impl.referenceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationReferenceDataSourceRequest
  ): zio.aws.kinesisanalytics.model.DeleteApplicationReferenceDataSourceRequest.ReadOnly =
    new Wrapper(impl)
}
