package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.InAppTableName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ReferenceDataSource(
    tableName: InAppTableName,
    s3ReferenceDataSource: Option[
      zio.aws.kinesisanalytics.model.S3ReferenceDataSource
    ] = None,
    referenceSchema: zio.aws.kinesisanalytics.model.SourceSchema
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSource = {
    import ReferenceDataSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSource
      .builder()
      .tableName(InAppTableName.unwrap(tableName): java.lang.String)
      .optionallyWith(
        s3ReferenceDataSource.map(value => value.buildAwsValue())
      )(_.s3ReferenceDataSource)
      .referenceSchema(referenceSchema.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalytics.model.ReferenceDataSource.ReadOnly =
    zio.aws.kinesisanalytics.model.ReferenceDataSource.wrap(buildAwsValue())
}
object ReferenceDataSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.ReferenceDataSource =
      zio.aws.kinesisanalytics.model.ReferenceDataSource(
        tableName,
        s3ReferenceDataSource.map(value => value.asEditable),
        referenceSchema.asEditable
      )
    def tableName: InAppTableName
    def s3ReferenceDataSource
        : Option[zio.aws.kinesisanalytics.model.S3ReferenceDataSource.ReadOnly]
    def referenceSchema: zio.aws.kinesisanalytics.model.SourceSchema.ReadOnly
    def getTableName: ZIO[Any, Nothing, InAppTableName] = ZIO.succeed(tableName)
    def getS3ReferenceDataSource: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.S3ReferenceDataSource.ReadOnly
    ] =
      AwsError.unwrapOptionField("s3ReferenceDataSource", s3ReferenceDataSource)
    def getReferenceSchema: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisanalytics.model.SourceSchema.ReadOnly
    ] = ZIO.succeed(referenceSchema)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSource
  ) extends zio.aws.kinesisanalytics.model.ReferenceDataSource.ReadOnly {
    override val tableName: InAppTableName =
      zio.aws.kinesisanalytics.model.primitives.InAppTableName(impl.tableName())
    override val s3ReferenceDataSource: Option[
      zio.aws.kinesisanalytics.model.S3ReferenceDataSource.ReadOnly
    ] = scala
      .Option(impl.s3ReferenceDataSource())
      .map(value =>
        zio.aws.kinesisanalytics.model.S3ReferenceDataSource.wrap(value)
      )
    override val referenceSchema
        : zio.aws.kinesisanalytics.model.SourceSchema.ReadOnly =
      zio.aws.kinesisanalytics.model.SourceSchema.wrap(impl.referenceSchema())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSource
  ): zio.aws.kinesisanalytics.model.ReferenceDataSource.ReadOnly = new Wrapper(
    impl
  )
}
