package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.{InAppStreamName, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class OutputDescription(
    outputId: Option[Id] = None,
    name: Option[InAppStreamName] = None,
    kinesisStreamsOutputDescription: Option[
      zio.aws.kinesisanalytics.model.KinesisStreamsOutputDescription
    ] = None,
    kinesisFirehoseOutputDescription: Option[
      zio.aws.kinesisanalytics.model.KinesisFirehoseOutputDescription
    ] = None,
    lambdaOutputDescription: Option[
      zio.aws.kinesisanalytics.model.LambdaOutputDescription
    ] = None,
    destinationSchema: Option[
      zio.aws.kinesisanalytics.model.DestinationSchema
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.OutputDescription = {
    import OutputDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.OutputDescription
      .builder()
      .optionallyWith(
        outputId.map(value => Id.unwrap(value): java.lang.String)
      )(_.outputId)
      .optionallyWith(
        name.map(value => InAppStreamName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        kinesisStreamsOutputDescription.map(value => value.buildAwsValue())
      )(_.kinesisStreamsOutputDescription)
      .optionallyWith(
        kinesisFirehoseOutputDescription.map(value => value.buildAwsValue())
      )(_.kinesisFirehoseOutputDescription)
      .optionallyWith(
        lambdaOutputDescription.map(value => value.buildAwsValue())
      )(_.lambdaOutputDescription)
      .optionallyWith(destinationSchema.map(value => value.buildAwsValue()))(
        _.destinationSchema
      )
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalytics.model.OutputDescription.ReadOnly =
    zio.aws.kinesisanalytics.model.OutputDescription.wrap(buildAwsValue())
}
object OutputDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.OutputDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.OutputDescription =
      zio.aws.kinesisanalytics.model.OutputDescription(
        outputId.map(value => value),
        name.map(value => value),
        kinesisStreamsOutputDescription.map(value => value.asEditable),
        kinesisFirehoseOutputDescription.map(value => value.asEditable),
        lambdaOutputDescription.map(value => value.asEditable),
        destinationSchema.map(value => value.asEditable)
      )
    def outputId: Option[Id]
    def name: Option[InAppStreamName]
    def kinesisStreamsOutputDescription: Option[
      zio.aws.kinesisanalytics.model.KinesisStreamsOutputDescription.ReadOnly
    ]
    def kinesisFirehoseOutputDescription: Option[
      zio.aws.kinesisanalytics.model.KinesisFirehoseOutputDescription.ReadOnly
    ]
    def lambdaOutputDescription: Option[
      zio.aws.kinesisanalytics.model.LambdaOutputDescription.ReadOnly
    ]
    def destinationSchema
        : Option[zio.aws.kinesisanalytics.model.DestinationSchema.ReadOnly]
    def getOutputId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("outputId", outputId)
    def getName: ZIO[Any, AwsError, InAppStreamName] =
      AwsError.unwrapOptionField("name", name)
    def getKinesisStreamsOutputDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.KinesisStreamsOutputDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kinesisStreamsOutputDescription",
      kinesisStreamsOutputDescription
    )
    def getKinesisFirehoseOutputDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.KinesisFirehoseOutputDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kinesisFirehoseOutputDescription",
      kinesisFirehoseOutputDescription
    )
    def getLambdaOutputDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.LambdaOutputDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lambdaOutputDescription",
      lambdaOutputDescription
    )
    def getDestinationSchema: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.DestinationSchema.ReadOnly
    ] = AwsError.unwrapOptionField("destinationSchema", destinationSchema)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.OutputDescription
  ) extends zio.aws.kinesisanalytics.model.OutputDescription.ReadOnly {
    override val outputId: Option[Id] = scala
      .Option(impl.outputId())
      .map(value => zio.aws.kinesisanalytics.model.primitives.Id(value))
    override val name: Option[InAppStreamName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.kinesisanalytics.model.primitives.InAppStreamName(value)
      )
    override val kinesisStreamsOutputDescription: Option[
      zio.aws.kinesisanalytics.model.KinesisStreamsOutputDescription.ReadOnly
    ] = scala
      .Option(impl.kinesisStreamsOutputDescription())
      .map(value =>
        zio.aws.kinesisanalytics.model.KinesisStreamsOutputDescription
          .wrap(value)
      )
    override val kinesisFirehoseOutputDescription: Option[
      zio.aws.kinesisanalytics.model.KinesisFirehoseOutputDescription.ReadOnly
    ] = scala
      .Option(impl.kinesisFirehoseOutputDescription())
      .map(value =>
        zio.aws.kinesisanalytics.model.KinesisFirehoseOutputDescription
          .wrap(value)
      )
    override val lambdaOutputDescription: Option[
      zio.aws.kinesisanalytics.model.LambdaOutputDescription.ReadOnly
    ] = scala
      .Option(impl.lambdaOutputDescription())
      .map(value =>
        zio.aws.kinesisanalytics.model.LambdaOutputDescription.wrap(value)
      )
    override val destinationSchema
        : Option[zio.aws.kinesisanalytics.model.DestinationSchema.ReadOnly] =
      scala
        .Option(impl.destinationSchema())
        .map(value =>
          zio.aws.kinesisanalytics.model.DestinationSchema.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.OutputDescription
  ): zio.aws.kinesisanalytics.model.OutputDescription.ReadOnly = new Wrapper(
    impl
  )
}
