package zio.aws.kinesisanalytics
import zio.mock.{Proxy, Mock}
import zio.aws.kinesisanalytics.model.TagResourceResponse.ReadOnly
import software.amazon.awssdk.services.kinesisanalytics.KinesisAnalyticsAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.kinesisanalytics.model.{
  UpdateApplicationRequest,
  DeleteApplicationCloudWatchLoggingOptionRequest,
  DeleteApplicationRequest,
  AddApplicationOutputRequest,
  StartApplicationRequest,
  AddApplicationReferenceDataSourceRequest,
  AddApplicationCloudWatchLoggingOptionRequest,
  CreateApplicationRequest,
  ListTagsForResourceRequest,
  DiscoverInputSchemaRequest,
  DeleteApplicationInputProcessingConfigurationRequest,
  DescribeApplicationRequest,
  UntagResourceRequest,
  ListApplicationsRequest,
  AddApplicationInputProcessingConfigurationRequest,
  StopApplicationRequest,
  DeleteApplicationReferenceDataSourceRequest,
  DeleteApplicationOutputRequest,
  TagResourceRequest,
  AddApplicationInputRequest
}
object KinesisAnalyticsMock extends Mock[KinesisAnalytics] {
  object DeleteApplication
      extends Effect[
        DeleteApplicationRequest,
        AwsError,
        zio.aws.kinesisanalytics.model.DeleteApplicationResponse.ReadOnly
      ]
  object AddApplicationReferenceDataSource
      extends Effect[
        AddApplicationReferenceDataSourceRequest,
        AwsError,
        zio.aws.kinesisanalytics.model.AddApplicationReferenceDataSourceResponse.ReadOnly
      ]
  object DescribeApplication
      extends Effect[
        DescribeApplicationRequest,
        AwsError,
        zio.aws.kinesisanalytics.model.DescribeApplicationResponse.ReadOnly
      ]
  object DeleteApplicationOutput
      extends Effect[
        DeleteApplicationOutputRequest,
        AwsError,
        zio.aws.kinesisanalytics.model.DeleteApplicationOutputResponse.ReadOnly
      ]
  object CreateApplication
      extends Effect[
        CreateApplicationRequest,
        AwsError,
        zio.aws.kinesisanalytics.model.CreateApplicationResponse.ReadOnly
      ]
  object DiscoverInputSchema
      extends Effect[
        DiscoverInputSchemaRequest,
        AwsError,
        zio.aws.kinesisanalytics.model.DiscoverInputSchemaResponse.ReadOnly
      ]
  object DeleteApplicationInputProcessingConfiguration
      extends Effect[
        DeleteApplicationInputProcessingConfigurationRequest,
        AwsError,
        zio.aws.kinesisanalytics.model.DeleteApplicationInputProcessingConfigurationResponse.ReadOnly
      ]
  object AddApplicationCloudWatchLoggingOption
      extends Effect[
        AddApplicationCloudWatchLoggingOptionRequest,
        AwsError,
        zio.aws.kinesisanalytics.model.AddApplicationCloudWatchLoggingOptionResponse.ReadOnly
      ]
  object AddApplicationOutput
      extends Effect[
        AddApplicationOutputRequest,
        AwsError,
        zio.aws.kinesisanalytics.model.AddApplicationOutputResponse.ReadOnly
      ]
  object StartApplication
      extends Effect[
        StartApplicationRequest,
        AwsError,
        zio.aws.kinesisanalytics.model.StartApplicationResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.kinesisanalytics.model.UntagResourceResponse.ReadOnly
      ]
  object DeleteApplicationCloudWatchLoggingOption
      extends Effect[
        DeleteApplicationCloudWatchLoggingOptionRequest,
        AwsError,
        zio.aws.kinesisanalytics.model.DeleteApplicationCloudWatchLoggingOptionResponse.ReadOnly
      ]
  object AddApplicationInputProcessingConfiguration
      extends Effect[
        AddApplicationInputProcessingConfigurationRequest,
        AwsError,
        zio.aws.kinesisanalytics.model.AddApplicationInputProcessingConfigurationResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.kinesisanalytics.model.ListTagsForResourceResponse.ReadOnly
      ]
  object AddApplicationInput
      extends Effect[
        AddApplicationInputRequest,
        AwsError,
        zio.aws.kinesisanalytics.model.AddApplicationInputResponse.ReadOnly
      ]
  object TagResource extends Effect[TagResourceRequest, AwsError, ReadOnly]
  object ListApplications
      extends Effect[
        ListApplicationsRequest,
        AwsError,
        zio.aws.kinesisanalytics.model.ListApplicationsResponse.ReadOnly
      ]
  object UpdateApplication
      extends Effect[
        UpdateApplicationRequest,
        AwsError,
        zio.aws.kinesisanalytics.model.UpdateApplicationResponse.ReadOnly
      ]
  object DeleteApplicationReferenceDataSource
      extends Effect[
        DeleteApplicationReferenceDataSourceRequest,
        AwsError,
        zio.aws.kinesisanalytics.model.DeleteApplicationReferenceDataSourceResponse.ReadOnly
      ]
  object StopApplication
      extends Effect[
        StopApplicationRequest,
        AwsError,
        zio.aws.kinesisanalytics.model.StopApplicationResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, KinesisAnalytics] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new KinesisAnalytics {
          val api: KinesisAnalyticsAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : KinesisAnalytics = this
          def deleteApplication(request: DeleteApplicationRequest): IO[
            AwsError,
            zio.aws.kinesisanalytics.model.DeleteApplicationResponse.ReadOnly
          ] = proxy(DeleteApplication, request)
          def addApplicationReferenceDataSource(
              request: AddApplicationReferenceDataSourceRequest
          ): IO[
            AwsError,
            zio.aws.kinesisanalytics.model.AddApplicationReferenceDataSourceResponse.ReadOnly
          ] = proxy(AddApplicationReferenceDataSource, request)
          def describeApplication(request: DescribeApplicationRequest): IO[
            AwsError,
            zio.aws.kinesisanalytics.model.DescribeApplicationResponse.ReadOnly
          ] = proxy(DescribeApplication, request)
          def deleteApplicationOutput(
              request: DeleteApplicationOutputRequest
          ): IO[
            AwsError,
            zio.aws.kinesisanalytics.model.DeleteApplicationOutputResponse.ReadOnly
          ] = proxy(DeleteApplicationOutput, request)
          def createApplication(request: CreateApplicationRequest): IO[
            AwsError,
            zio.aws.kinesisanalytics.model.CreateApplicationResponse.ReadOnly
          ] = proxy(CreateApplication, request)
          def discoverInputSchema(request: DiscoverInputSchemaRequest): IO[
            AwsError,
            zio.aws.kinesisanalytics.model.DiscoverInputSchemaResponse.ReadOnly
          ] = proxy(DiscoverInputSchema, request)
          def deleteApplicationInputProcessingConfiguration(
              request: DeleteApplicationInputProcessingConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.kinesisanalytics.model.DeleteApplicationInputProcessingConfigurationResponse.ReadOnly
          ] = proxy(DeleteApplicationInputProcessingConfiguration, request)
          def addApplicationCloudWatchLoggingOption(
              request: AddApplicationCloudWatchLoggingOptionRequest
          ): IO[
            AwsError,
            zio.aws.kinesisanalytics.model.AddApplicationCloudWatchLoggingOptionResponse.ReadOnly
          ] = proxy(AddApplicationCloudWatchLoggingOption, request)
          def addApplicationOutput(request: AddApplicationOutputRequest): IO[
            AwsError,
            zio.aws.kinesisanalytics.model.AddApplicationOutputResponse.ReadOnly
          ] = proxy(AddApplicationOutput, request)
          def startApplication(request: StartApplicationRequest): IO[
            AwsError,
            zio.aws.kinesisanalytics.model.StartApplicationResponse.ReadOnly
          ] = proxy(StartApplication, request)
          def untagResource(request: UntagResourceRequest): IO[
            AwsError,
            zio.aws.kinesisanalytics.model.UntagResourceResponse.ReadOnly
          ] = proxy(UntagResource, request)
          def deleteApplicationCloudWatchLoggingOption(
              request: DeleteApplicationCloudWatchLoggingOptionRequest
          ): IO[
            AwsError,
            zio.aws.kinesisanalytics.model.DeleteApplicationCloudWatchLoggingOptionResponse.ReadOnly
          ] = proxy(DeleteApplicationCloudWatchLoggingOption, request)
          def addApplicationInputProcessingConfiguration(
              request: AddApplicationInputProcessingConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.kinesisanalytics.model.AddApplicationInputProcessingConfigurationResponse.ReadOnly
          ] = proxy(AddApplicationInputProcessingConfiguration, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.kinesisanalytics.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def addApplicationInput(request: AddApplicationInputRequest): IO[
            AwsError,
            zio.aws.kinesisanalytics.model.AddApplicationInputResponse.ReadOnly
          ] = proxy(AddApplicationInput, request)
          def tagResource(request: TagResourceRequest): IO[AwsError, ReadOnly] =
            proxy(TagResource, request)
          def listApplications(request: ListApplicationsRequest): IO[
            AwsError,
            zio.aws.kinesisanalytics.model.ListApplicationsResponse.ReadOnly
          ] = proxy(ListApplications, request)
          def updateApplication(request: UpdateApplicationRequest): IO[
            AwsError,
            zio.aws.kinesisanalytics.model.UpdateApplicationResponse.ReadOnly
          ] = proxy(UpdateApplication, request)
          def deleteApplicationReferenceDataSource(
              request: DeleteApplicationReferenceDataSourceRequest
          ): IO[
            AwsError,
            zio.aws.kinesisanalytics.model.DeleteApplicationReferenceDataSourceResponse.ReadOnly
          ] = proxy(DeleteApplicationReferenceDataSource, request)
          def stopApplication(request: StopApplicationRequest): IO[
            AwsError,
            zio.aws.kinesisanalytics.model.StopApplicationResponse.ReadOnly
          ] = proxy(StopApplication, request)
        }
      }
    }
    .toLayer
}
