package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.ApplicationName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeApplicationRequest(applicationName: ApplicationName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.DescribeApplicationRequest = {
    import DescribeApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.DescribeApplicationRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalytics.model.DescribeApplicationRequest.ReadOnly =
    zio.aws.kinesisanalytics.model.DescribeApplicationRequest
      .wrap(buildAwsValue())
}
object DescribeApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.DescribeApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.DescribeApplicationRequest =
      zio.aws.kinesisanalytics.model.DescribeApplicationRequest(applicationName)
    def applicationName: ApplicationName
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.DescribeApplicationRequest
  ) extends zio.aws.kinesisanalytics.model.DescribeApplicationRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.kinesisanalytics.model.primitives
        .ApplicationName(impl.applicationName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.DescribeApplicationRequest
  ): zio.aws.kinesisanalytics.model.DescribeApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
