package zio.aws.kinesisanalytics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class InputProcessingConfiguration(
    inputLambdaProcessor: zio.aws.kinesisanalytics.model.InputLambdaProcessor
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.InputProcessingConfiguration = {
    import InputProcessingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.InputProcessingConfiguration
      .builder()
      .inputLambdaProcessor(inputLambdaProcessor.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalytics.model.InputProcessingConfiguration.ReadOnly =
    zio.aws.kinesisanalytics.model.InputProcessingConfiguration
      .wrap(buildAwsValue())
}
object InputProcessingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.InputProcessingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalytics.model.InputProcessingConfiguration =
      zio.aws.kinesisanalytics.model
        .InputProcessingConfiguration(inputLambdaProcessor.asEditable)
    def inputLambdaProcessor
        : zio.aws.kinesisanalytics.model.InputLambdaProcessor.ReadOnly
    def getInputLambdaProcessor: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisanalytics.model.InputLambdaProcessor.ReadOnly
    ] = ZIO.succeed(inputLambdaProcessor)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.InputProcessingConfiguration
  ) extends zio.aws.kinesisanalytics.model.InputProcessingConfiguration.ReadOnly {
    override val inputLambdaProcessor
        : zio.aws.kinesisanalytics.model.InputLambdaProcessor.ReadOnly =
      zio.aws.kinesisanalytics.model.InputLambdaProcessor
        .wrap(impl.inputLambdaProcessor())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.InputProcessingConfiguration
  ): zio.aws.kinesisanalytics.model.InputProcessingConfiguration.ReadOnly =
    new Wrapper(impl)
}
