package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.ApplicationCode
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ApplicationUpdate(
    inputUpdates: Option[Iterable[zio.aws.kinesisanalytics.model.InputUpdate]] =
      None,
    applicationCodeUpdate: Option[ApplicationCode] = None,
    outputUpdates: Option[
      Iterable[zio.aws.kinesisanalytics.model.OutputUpdate]
    ] = None,
    referenceDataSourceUpdates: Option[
      Iterable[zio.aws.kinesisanalytics.model.ReferenceDataSourceUpdate]
    ] = None,
    cloudWatchLoggingOptionUpdates: Option[
      Iterable[zio.aws.kinesisanalytics.model.CloudWatchLoggingOptionUpdate]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.ApplicationUpdate = {
    import ApplicationUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.ApplicationUpdate
      .builder()
      .optionallyWith(
        inputUpdates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inputUpdates)
      .optionallyWith(
        applicationCodeUpdate.map(value =>
          ApplicationCode.unwrap(value): java.lang.String
        )
      )(_.applicationCodeUpdate)
      .optionallyWith(
        outputUpdates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.outputUpdates)
      .optionallyWith(
        referenceDataSourceUpdates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.referenceDataSourceUpdates)
      .optionallyWith(
        cloudWatchLoggingOptionUpdates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cloudWatchLoggingOptionUpdates)
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalytics.model.ApplicationUpdate.ReadOnly =
    zio.aws.kinesisanalytics.model.ApplicationUpdate.wrap(buildAwsValue())
}
object ApplicationUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.ApplicationUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.ApplicationUpdate =
      zio.aws.kinesisanalytics.model.ApplicationUpdate(
        inputUpdates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        applicationCodeUpdate.map(value => value),
        outputUpdates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        referenceDataSourceUpdates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cloudWatchLoggingOptionUpdates.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def inputUpdates
        : Option[List[zio.aws.kinesisanalytics.model.InputUpdate.ReadOnly]]
    def applicationCodeUpdate: Option[ApplicationCode]
    def outputUpdates
        : Option[List[zio.aws.kinesisanalytics.model.OutputUpdate.ReadOnly]]
    def referenceDataSourceUpdates: Option[
      List[zio.aws.kinesisanalytics.model.ReferenceDataSourceUpdate.ReadOnly]
    ]
    def cloudWatchLoggingOptionUpdates: Option[List[
      zio.aws.kinesisanalytics.model.CloudWatchLoggingOptionUpdate.ReadOnly
    ]]
    def getInputUpdates: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalytics.model.InputUpdate.ReadOnly
    ]] = AwsError.unwrapOptionField("inputUpdates", inputUpdates)
    def getApplicationCodeUpdate: ZIO[Any, AwsError, ApplicationCode] =
      AwsError.unwrapOptionField("applicationCodeUpdate", applicationCodeUpdate)
    def getOutputUpdates: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalytics.model.OutputUpdate.ReadOnly
    ]] = AwsError.unwrapOptionField("outputUpdates", outputUpdates)
    def getReferenceDataSourceUpdates: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalytics.model.ReferenceDataSourceUpdate.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "referenceDataSourceUpdates",
      referenceDataSourceUpdates
    )
    def getCloudWatchLoggingOptionUpdates: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalytics.model.CloudWatchLoggingOptionUpdate.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "cloudWatchLoggingOptionUpdates",
      cloudWatchLoggingOptionUpdates
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.ApplicationUpdate
  ) extends zio.aws.kinesisanalytics.model.ApplicationUpdate.ReadOnly {
    override val inputUpdates
        : Option[List[zio.aws.kinesisanalytics.model.InputUpdate.ReadOnly]] =
      scala
        .Option(impl.inputUpdates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kinesisanalytics.model.InputUpdate.wrap(item)
          }.toList
        )
    override val applicationCodeUpdate: Option[ApplicationCode] = scala
      .Option(impl.applicationCodeUpdate())
      .map(value =>
        zio.aws.kinesisanalytics.model.primitives.ApplicationCode(value)
      )
    override val outputUpdates
        : Option[List[zio.aws.kinesisanalytics.model.OutputUpdate.ReadOnly]] =
      scala
        .Option(impl.outputUpdates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kinesisanalytics.model.OutputUpdate.wrap(item)
          }.toList
        )
    override val referenceDataSourceUpdates: Option[
      List[zio.aws.kinesisanalytics.model.ReferenceDataSourceUpdate.ReadOnly]
    ] = scala
      .Option(impl.referenceDataSourceUpdates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalytics.model.ReferenceDataSourceUpdate.wrap(item)
        }.toList
      )
    override val cloudWatchLoggingOptionUpdates: Option[List[
      zio.aws.kinesisanalytics.model.CloudWatchLoggingOptionUpdate.ReadOnly
    ]] = scala
      .Option(impl.cloudWatchLoggingOptionUpdates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalytics.model.CloudWatchLoggingOptionUpdate
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.ApplicationUpdate
  ): zio.aws.kinesisanalytics.model.ApplicationUpdate.ReadOnly = new Wrapper(
    impl
  )
}
