package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.{ResourceARN, ApplicationName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ApplicationSummary(
    applicationName: ApplicationName,
    applicationARN: ResourceARN,
    applicationStatus: zio.aws.kinesisanalytics.model.ApplicationStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.ApplicationSummary = {
    import ApplicationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.ApplicationSummary
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .applicationARN(ResourceARN.unwrap(applicationARN): java.lang.String)
      .applicationStatus(applicationStatus.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalytics.model.ApplicationSummary.ReadOnly =
    zio.aws.kinesisanalytics.model.ApplicationSummary.wrap(buildAwsValue())
}
object ApplicationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.ApplicationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.ApplicationSummary =
      zio.aws.kinesisanalytics.model
        .ApplicationSummary(applicationName, applicationARN, applicationStatus)
    def applicationName: ApplicationName
    def applicationARN: ResourceARN
    def applicationStatus: zio.aws.kinesisanalytics.model.ApplicationStatus
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getApplicationARN: ZIO[Any, Nothing, ResourceARN] =
      ZIO.succeed(applicationARN)
    def getApplicationStatus
        : ZIO[Any, Nothing, zio.aws.kinesisanalytics.model.ApplicationStatus] =
      ZIO.succeed(applicationStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.ApplicationSummary
  ) extends zio.aws.kinesisanalytics.model.ApplicationSummary.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.kinesisanalytics.model.primitives
        .ApplicationName(impl.applicationName())
    override val applicationARN: ResourceARN =
      zio.aws.kinesisanalytics.model.primitives
        .ResourceARN(impl.applicationARN())
    override val applicationStatus
        : zio.aws.kinesisanalytics.model.ApplicationStatus =
      zio.aws.kinesisanalytics.model.ApplicationStatus
        .wrap(impl.applicationStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.ApplicationSummary
  ): zio.aws.kinesisanalytics.model.ApplicationSummary.ReadOnly = new Wrapper(
    impl
  )
}
