package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.{InAppTableName, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ReferenceDataSourceDescription(
    referenceId: Id,
    tableName: InAppTableName,
    s3ReferenceDataSourceDescription: zio.aws.kinesisanalytics.model.S3ReferenceDataSourceDescription,
    referenceSchema: Option[zio.aws.kinesisanalytics.model.SourceSchema] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSourceDescription = {
    import ReferenceDataSourceDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSourceDescription
      .builder()
      .referenceId(Id.unwrap(referenceId): java.lang.String)
      .tableName(InAppTableName.unwrap(tableName): java.lang.String)
      .s3ReferenceDataSourceDescription(
        s3ReferenceDataSourceDescription.buildAwsValue()
      )
      .optionallyWith(referenceSchema.map(value => value.buildAwsValue()))(
        _.referenceSchema
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalytics.model.ReferenceDataSourceDescription.ReadOnly =
    zio.aws.kinesisanalytics.model.ReferenceDataSourceDescription
      .wrap(buildAwsValue())
}
object ReferenceDataSourceDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSourceDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalytics.model.ReferenceDataSourceDescription =
      zio.aws.kinesisanalytics.model.ReferenceDataSourceDescription(
        referenceId,
        tableName,
        s3ReferenceDataSourceDescription.asEditable,
        referenceSchema.map(value => value.asEditable)
      )
    def referenceId: Id
    def tableName: InAppTableName
    def s3ReferenceDataSourceDescription
        : zio.aws.kinesisanalytics.model.S3ReferenceDataSourceDescription.ReadOnly
    def referenceSchema
        : Option[zio.aws.kinesisanalytics.model.SourceSchema.ReadOnly]
    def getReferenceId: ZIO[Any, Nothing, Id] = ZIO.succeed(referenceId)
    def getTableName: ZIO[Any, Nothing, InAppTableName] = ZIO.succeed(tableName)
    def getS3ReferenceDataSourceDescription: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisanalytics.model.S3ReferenceDataSourceDescription.ReadOnly
    ] = ZIO.succeed(s3ReferenceDataSourceDescription)
    def getReferenceSchema: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.SourceSchema.ReadOnly
    ] = AwsError.unwrapOptionField("referenceSchema", referenceSchema)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSourceDescription
  ) extends zio.aws.kinesisanalytics.model.ReferenceDataSourceDescription.ReadOnly {
    override val referenceId: Id =
      zio.aws.kinesisanalytics.model.primitives.Id(impl.referenceId())
    override val tableName: InAppTableName =
      zio.aws.kinesisanalytics.model.primitives.InAppTableName(impl.tableName())
    override val s3ReferenceDataSourceDescription
        : zio.aws.kinesisanalytics.model.S3ReferenceDataSourceDescription.ReadOnly =
      zio.aws.kinesisanalytics.model.S3ReferenceDataSourceDescription
        .wrap(impl.s3ReferenceDataSourceDescription())
    override val referenceSchema
        : Option[zio.aws.kinesisanalytics.model.SourceSchema.ReadOnly] = scala
      .Option(impl.referenceSchema())
      .map(value => zio.aws.kinesisanalytics.model.SourceSchema.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSourceDescription
  ): zio.aws.kinesisanalytics.model.ReferenceDataSourceDescription.ReadOnly =
    new Wrapper(impl)
}
