package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.{InAppStreamName, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InputDescription(
    inputId: Option[Id] = None,
    namePrefix: Option[InAppStreamName] = None,
    inAppStreamNames: Option[Iterable[InAppStreamName]] = None,
    inputProcessingConfigurationDescription: Option[
      zio.aws.kinesisanalytics.model.InputProcessingConfigurationDescription
    ] = None,
    kinesisStreamsInputDescription: Option[
      zio.aws.kinesisanalytics.model.KinesisStreamsInputDescription
    ] = None,
    kinesisFirehoseInputDescription: Option[
      zio.aws.kinesisanalytics.model.KinesisFirehoseInputDescription
    ] = None,
    inputSchema: Option[zio.aws.kinesisanalytics.model.SourceSchema] = None,
    inputParallelism: Option[zio.aws.kinesisanalytics.model.InputParallelism] =
      None,
    inputStartingPositionConfiguration: Option[
      zio.aws.kinesisanalytics.model.InputStartingPositionConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.InputDescription = {
    import InputDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.InputDescription
      .builder()
      .optionallyWith(inputId.map(value => Id.unwrap(value): java.lang.String))(
        _.inputId
      )
      .optionallyWith(
        namePrefix.map(value => InAppStreamName.unwrap(value): java.lang.String)
      )(_.namePrefix)
      .optionallyWith(
        inAppStreamNames.map(value =>
          value.map { item =>
            InAppStreamName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.inAppStreamNames)
      .optionallyWith(
        inputProcessingConfigurationDescription.map(value =>
          value.buildAwsValue()
        )
      )(_.inputProcessingConfigurationDescription)
      .optionallyWith(
        kinesisStreamsInputDescription.map(value => value.buildAwsValue())
      )(_.kinesisStreamsInputDescription)
      .optionallyWith(
        kinesisFirehoseInputDescription.map(value => value.buildAwsValue())
      )(_.kinesisFirehoseInputDescription)
      .optionallyWith(inputSchema.map(value => value.buildAwsValue()))(
        _.inputSchema
      )
      .optionallyWith(inputParallelism.map(value => value.buildAwsValue()))(
        _.inputParallelism
      )
      .optionallyWith(
        inputStartingPositionConfiguration.map(value => value.buildAwsValue())
      )(_.inputStartingPositionConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalytics.model.InputDescription.ReadOnly =
    zio.aws.kinesisanalytics.model.InputDescription.wrap(buildAwsValue())
}
object InputDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.InputDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.InputDescription =
      zio.aws.kinesisanalytics.model.InputDescription(
        inputId.map(value => value),
        namePrefix.map(value => value),
        inAppStreamNames.map(value => value),
        inputProcessingConfigurationDescription.map(value => value.asEditable),
        kinesisStreamsInputDescription.map(value => value.asEditable),
        kinesisFirehoseInputDescription.map(value => value.asEditable),
        inputSchema.map(value => value.asEditable),
        inputParallelism.map(value => value.asEditable),
        inputStartingPositionConfiguration.map(value => value.asEditable)
      )
    def inputId: Option[Id]
    def namePrefix: Option[InAppStreamName]
    def inAppStreamNames: Option[List[InAppStreamName]]
    def inputProcessingConfigurationDescription: Option[
      zio.aws.kinesisanalytics.model.InputProcessingConfigurationDescription.ReadOnly
    ]
    def kinesisStreamsInputDescription: Option[
      zio.aws.kinesisanalytics.model.KinesisStreamsInputDescription.ReadOnly
    ]
    def kinesisFirehoseInputDescription: Option[
      zio.aws.kinesisanalytics.model.KinesisFirehoseInputDescription.ReadOnly
    ]
    def inputSchema
        : Option[zio.aws.kinesisanalytics.model.SourceSchema.ReadOnly]
    def inputParallelism
        : Option[zio.aws.kinesisanalytics.model.InputParallelism.ReadOnly]
    def inputStartingPositionConfiguration: Option[
      zio.aws.kinesisanalytics.model.InputStartingPositionConfiguration.ReadOnly
    ]
    def getInputId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("inputId", inputId)
    def getNamePrefix: ZIO[Any, AwsError, InAppStreamName] =
      AwsError.unwrapOptionField("namePrefix", namePrefix)
    def getInAppStreamNames: ZIO[Any, AwsError, List[InAppStreamName]] =
      AwsError.unwrapOptionField("inAppStreamNames", inAppStreamNames)
    def getInputProcessingConfigurationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.InputProcessingConfigurationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inputProcessingConfigurationDescription",
      inputProcessingConfigurationDescription
    )
    def getKinesisStreamsInputDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.KinesisStreamsInputDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kinesisStreamsInputDescription",
      kinesisStreamsInputDescription
    )
    def getKinesisFirehoseInputDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.KinesisFirehoseInputDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kinesisFirehoseInputDescription",
      kinesisFirehoseInputDescription
    )
    def getInputSchema: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.SourceSchema.ReadOnly
    ] = AwsError.unwrapOptionField("inputSchema", inputSchema)
    def getInputParallelism: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.InputParallelism.ReadOnly
    ] = AwsError.unwrapOptionField("inputParallelism", inputParallelism)
    def getInputStartingPositionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.InputStartingPositionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inputStartingPositionConfiguration",
      inputStartingPositionConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.InputDescription
  ) extends zio.aws.kinesisanalytics.model.InputDescription.ReadOnly {
    override val inputId: Option[Id] = scala
      .Option(impl.inputId())
      .map(value => zio.aws.kinesisanalytics.model.primitives.Id(value))
    override val namePrefix: Option[InAppStreamName] = scala
      .Option(impl.namePrefix())
      .map(value =>
        zio.aws.kinesisanalytics.model.primitives.InAppStreamName(value)
      )
    override val inAppStreamNames: Option[List[InAppStreamName]] = scala
      .Option(impl.inAppStreamNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalytics.model.primitives.InAppStreamName(item)
        }.toList
      )
    override val inputProcessingConfigurationDescription: Option[
      zio.aws.kinesisanalytics.model.InputProcessingConfigurationDescription.ReadOnly
    ] = scala
      .Option(impl.inputProcessingConfigurationDescription())
      .map(value =>
        zio.aws.kinesisanalytics.model.InputProcessingConfigurationDescription
          .wrap(value)
      )
    override val kinesisStreamsInputDescription: Option[
      zio.aws.kinesisanalytics.model.KinesisStreamsInputDescription.ReadOnly
    ] = scala
      .Option(impl.kinesisStreamsInputDescription())
      .map(value =>
        zio.aws.kinesisanalytics.model.KinesisStreamsInputDescription
          .wrap(value)
      )
    override val kinesisFirehoseInputDescription: Option[
      zio.aws.kinesisanalytics.model.KinesisFirehoseInputDescription.ReadOnly
    ] = scala
      .Option(impl.kinesisFirehoseInputDescription())
      .map(value =>
        zio.aws.kinesisanalytics.model.KinesisFirehoseInputDescription
          .wrap(value)
      )
    override val inputSchema
        : Option[zio.aws.kinesisanalytics.model.SourceSchema.ReadOnly] = scala
      .Option(impl.inputSchema())
      .map(value => zio.aws.kinesisanalytics.model.SourceSchema.wrap(value))
    override val inputParallelism
        : Option[zio.aws.kinesisanalytics.model.InputParallelism.ReadOnly] =
      scala
        .Option(impl.inputParallelism())
        .map(value =>
          zio.aws.kinesisanalytics.model.InputParallelism.wrap(value)
        )
    override val inputStartingPositionConfiguration: Option[
      zio.aws.kinesisanalytics.model.InputStartingPositionConfiguration.ReadOnly
    ] = scala
      .Option(impl.inputStartingPositionConfiguration())
      .map(value =>
        zio.aws.kinesisanalytics.model.InputStartingPositionConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.InputDescription
  ): zio.aws.kinesisanalytics.model.InputDescription.ReadOnly = new Wrapper(
    impl
  )
}
