package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.{RoleARN, FileKey, BucketARN}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class S3ReferenceDataSourceUpdate(
    bucketARNUpdate: Option[BucketARN] = None,
    fileKeyUpdate: Option[FileKey] = None,
    referenceRoleARNUpdate: Option[RoleARN] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.S3ReferenceDataSourceUpdate = {
    import S3ReferenceDataSourceUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.S3ReferenceDataSourceUpdate
      .builder()
      .optionallyWith(
        bucketARNUpdate.map(value => BucketARN.unwrap(value): java.lang.String)
      )(_.bucketARNUpdate)
      .optionallyWith(
        fileKeyUpdate.map(value => FileKey.unwrap(value): java.lang.String)
      )(_.fileKeyUpdate)
      .optionallyWith(
        referenceRoleARNUpdate.map(value =>
          RoleARN.unwrap(value): java.lang.String
        )
      )(_.referenceRoleARNUpdate)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalytics.model.S3ReferenceDataSourceUpdate.ReadOnly =
    zio.aws.kinesisanalytics.model.S3ReferenceDataSourceUpdate
      .wrap(buildAwsValue())
}
object S3ReferenceDataSourceUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.S3ReferenceDataSourceUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.S3ReferenceDataSourceUpdate =
      zio.aws.kinesisanalytics.model.S3ReferenceDataSourceUpdate(
        bucketARNUpdate.map(value => value),
        fileKeyUpdate.map(value => value),
        referenceRoleARNUpdate.map(value => value)
      )
    def bucketARNUpdate: Option[BucketARN]
    def fileKeyUpdate: Option[FileKey]
    def referenceRoleARNUpdate: Option[RoleARN]
    def getBucketARNUpdate: ZIO[Any, AwsError, BucketARN] =
      AwsError.unwrapOptionField("bucketARNUpdate", bucketARNUpdate)
    def getFileKeyUpdate: ZIO[Any, AwsError, FileKey] =
      AwsError.unwrapOptionField("fileKeyUpdate", fileKeyUpdate)
    def getReferenceRoleARNUpdate: ZIO[Any, AwsError, RoleARN] = AwsError
      .unwrapOptionField("referenceRoleARNUpdate", referenceRoleARNUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.S3ReferenceDataSourceUpdate
  ) extends zio.aws.kinesisanalytics.model.S3ReferenceDataSourceUpdate.ReadOnly {
    override val bucketARNUpdate: Option[BucketARN] = scala
      .Option(impl.bucketARNUpdate())
      .map(value => zio.aws.kinesisanalytics.model.primitives.BucketARN(value))
    override val fileKeyUpdate: Option[FileKey] = scala
      .Option(impl.fileKeyUpdate())
      .map(value => zio.aws.kinesisanalytics.model.primitives.FileKey(value))
    override val referenceRoleARNUpdate: Option[RoleARN] = scala
      .Option(impl.referenceRoleARNUpdate())
      .map(value => zio.aws.kinesisanalytics.model.primitives.RoleARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.S3ReferenceDataSourceUpdate
  ): zio.aws.kinesisanalytics.model.S3ReferenceDataSourceUpdate.ReadOnly =
    new Wrapper(impl)
}
