package zio.aws.kinesisanalytics.model
import java.lang.Integer
import zio.aws.kinesisanalytics.model.primitives.{
  ApplicationName,
  ListApplicationsInputLimit
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListApplicationsRequest(
    limit: Option[ListApplicationsInputLimit] = None,
    exclusiveStartApplicationName: Option[ApplicationName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.ListApplicationsRequest = {
    import ListApplicationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.ListApplicationsRequest
      .builder()
      .optionallyWith(
        limit.map(value => ListApplicationsInputLimit.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        exclusiveStartApplicationName.map(value =>
          ApplicationName.unwrap(value): java.lang.String
        )
      )(_.exclusiveStartApplicationName)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalytics.model.ListApplicationsRequest.ReadOnly =
    zio.aws.kinesisanalytics.model.ListApplicationsRequest.wrap(buildAwsValue())
}
object ListApplicationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.ListApplicationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.ListApplicationsRequest =
      zio.aws.kinesisanalytics.model.ListApplicationsRequest(
        limit.map(value => value),
        exclusiveStartApplicationName.map(value => value)
      )
    def limit: Option[ListApplicationsInputLimit]
    def exclusiveStartApplicationName: Option[ApplicationName]
    def getLimit: ZIO[Any, AwsError, ListApplicationsInputLimit] =
      AwsError.unwrapOptionField("limit", limit)
    def getExclusiveStartApplicationName: ZIO[Any, AwsError, ApplicationName] =
      AwsError.unwrapOptionField(
        "exclusiveStartApplicationName",
        exclusiveStartApplicationName
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.ListApplicationsRequest
  ) extends zio.aws.kinesisanalytics.model.ListApplicationsRequest.ReadOnly {
    override val limit: Option[ListApplicationsInputLimit] = scala
      .Option(impl.limit())
      .map(value =>
        zio.aws.kinesisanalytics.model.primitives
          .ListApplicationsInputLimit(value)
      )
    override val exclusiveStartApplicationName: Option[ApplicationName] = scala
      .Option(impl.exclusiveStartApplicationName())
      .map(value =>
        zio.aws.kinesisanalytics.model.primitives.ApplicationName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.ListApplicationsRequest
  ): zio.aws.kinesisanalytics.model.ListApplicationsRequest.ReadOnly =
    new Wrapper(impl)
}
