package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.{RoleARN, ResourceARN}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InputLambdaProcessorDescription(
    resourceARN: Option[ResourceARN] = None,
    roleARN: Option[RoleARN] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.InputLambdaProcessorDescription = {
    import InputLambdaProcessorDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.InputLambdaProcessorDescription
      .builder()
      .optionallyWith(
        resourceARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.resourceARN)
      .optionallyWith(
        roleARN.map(value => RoleARN.unwrap(value): java.lang.String)
      )(_.roleARN)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalytics.model.InputLambdaProcessorDescription.ReadOnly =
    zio.aws.kinesisanalytics.model.InputLambdaProcessorDescription
      .wrap(buildAwsValue())
}
object InputLambdaProcessorDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.InputLambdaProcessorDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalytics.model.InputLambdaProcessorDescription =
      zio.aws.kinesisanalytics.model.InputLambdaProcessorDescription(
        resourceARN.map(value => value),
        roleARN.map(value => value)
      )
    def resourceARN: Option[ResourceARN]
    def roleARN: Option[RoleARN]
    def getResourceARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("resourceARN", resourceARN)
    def getRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("roleARN", roleARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.InputLambdaProcessorDescription
  ) extends zio.aws.kinesisanalytics.model.InputLambdaProcessorDescription.ReadOnly {
    override val resourceARN: Option[ResourceARN] = scala
      .Option(impl.resourceARN())
      .map(value =>
        zio.aws.kinesisanalytics.model.primitives.ResourceARN(value)
      )
    override val roleARN: Option[RoleARN] = scala
      .Option(impl.roleARN())
      .map(value => zio.aws.kinesisanalytics.model.primitives.RoleARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.InputLambdaProcessorDescription
  ): zio.aws.kinesisanalytics.model.InputLambdaProcessorDescription.ReadOnly =
    new Wrapper(impl)
}
