package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.{
  RawInputRecord,
  ProcessedInputRecord,
  ParsedInputRecordField
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DiscoverInputSchemaResponse(
    inputSchema: Option[zio.aws.kinesisanalytics.model.SourceSchema] = None,
    parsedInputRecords: Option[Iterable[Iterable[ParsedInputRecordField]]] =
      None,
    processedInputRecords: Option[Iterable[ProcessedInputRecord]] = None,
    rawInputRecords: Option[Iterable[RawInputRecord]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.DiscoverInputSchemaResponse = {
    import DiscoverInputSchemaResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.DiscoverInputSchemaResponse
      .builder()
      .optionallyWith(inputSchema.map(value => value.buildAwsValue()))(
        _.inputSchema
      )
      .optionallyWith(
        parsedInputRecords.map(value =>
          value.map { item =>
            item.map { item =>
              ParsedInputRecordField.unwrap(item): java.lang.String
            }.asJavaCollection
          }.asJavaCollection
        )
      )(_.parsedInputRecords)
      .optionallyWith(
        processedInputRecords.map(value =>
          value.map { item =>
            ProcessedInputRecord.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.processedInputRecords)
      .optionallyWith(
        rawInputRecords.map(value =>
          value.map { item =>
            RawInputRecord.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.rawInputRecords)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalytics.model.DiscoverInputSchemaResponse.ReadOnly =
    zio.aws.kinesisanalytics.model.DiscoverInputSchemaResponse
      .wrap(buildAwsValue())
}
object DiscoverInputSchemaResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.DiscoverInputSchemaResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.DiscoverInputSchemaResponse =
      zio.aws.kinesisanalytics.model.DiscoverInputSchemaResponse(
        inputSchema.map(value => value.asEditable),
        parsedInputRecords.map(value => value),
        processedInputRecords.map(value => value),
        rawInputRecords.map(value => value)
      )
    def inputSchema
        : Option[zio.aws.kinesisanalytics.model.SourceSchema.ReadOnly]
    def parsedInputRecords: Option[List[List[ParsedInputRecordField]]]
    def processedInputRecords: Option[List[ProcessedInputRecord]]
    def rawInputRecords: Option[List[RawInputRecord]]
    def getInputSchema: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.SourceSchema.ReadOnly
    ] = AwsError.unwrapOptionField("inputSchema", inputSchema)
    def getParsedInputRecords
        : ZIO[Any, AwsError, List[List[ParsedInputRecordField]]] =
      AwsError.unwrapOptionField("parsedInputRecords", parsedInputRecords)
    def getProcessedInputRecords
        : ZIO[Any, AwsError, List[ProcessedInputRecord]] =
      AwsError.unwrapOptionField("processedInputRecords", processedInputRecords)
    def getRawInputRecords: ZIO[Any, AwsError, List[RawInputRecord]] =
      AwsError.unwrapOptionField("rawInputRecords", rawInputRecords)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.DiscoverInputSchemaResponse
  ) extends zio.aws.kinesisanalytics.model.DiscoverInputSchemaResponse.ReadOnly {
    override val inputSchema
        : Option[zio.aws.kinesisanalytics.model.SourceSchema.ReadOnly] = scala
      .Option(impl.inputSchema())
      .map(value => zio.aws.kinesisanalytics.model.SourceSchema.wrap(value))
    override val parsedInputRecords
        : Option[List[List[ParsedInputRecordField]]] = scala
      .Option(impl.parsedInputRecords())
      .map(value =>
        value.asScala.map { item =>
          item.asScala.map { item =>
            zio.aws.kinesisanalytics.model.primitives
              .ParsedInputRecordField(item)
          }.toList
        }.toList
      )
    override val processedInputRecords: Option[List[ProcessedInputRecord]] =
      scala
        .Option(impl.processedInputRecords())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kinesisanalytics.model.primitives.ProcessedInputRecord(item)
          }.toList
        )
    override val rawInputRecords: Option[List[RawInputRecord]] = scala
      .Option(impl.rawInputRecords())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalytics.model.primitives.RawInputRecord(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.DiscoverInputSchemaResponse
  ): zio.aws.kinesisanalytics.model.DiscoverInputSchemaResponse.ReadOnly =
    new Wrapper(impl)
}
