package zio.aws.kinesisanalytics
import zio.aws.kinesisanalytics.model.primitives.{
  RawInputRecord,
  InAppStreamName,
  ProcessedInputRecord,
  ParsedInputRecordField,
  TagKey
}
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.kinesisanalytics.model.primitives.RecordRowDelimiter.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object ApplicationCode extends Subtype[String]
    type ApplicationCode =
      zio.aws.kinesisanalytics.model.primitives.ApplicationCode.Type
    object ApplicationDescription extends Subtype[String]
    type ApplicationDescription =
      zio.aws.kinesisanalytics.model.primitives.ApplicationDescription.Type
    object ApplicationName extends Subtype[String]
    type ApplicationName =
      zio.aws.kinesisanalytics.model.primitives.ApplicationName.Type
    object ApplicationVersionId extends Subtype[Long]
    type ApplicationVersionId =
      zio.aws.kinesisanalytics.model.primitives.ApplicationVersionId.Type
    object BooleanObject extends Subtype[Boolean]
    type BooleanObject =
      zio.aws.kinesisanalytics.model.primitives.BooleanObject.Type
    object BucketARN extends Subtype[String]
    type BucketARN = zio.aws.kinesisanalytics.model.primitives.BucketARN.Type
    object FileKey extends Subtype[String]
    type FileKey = zio.aws.kinesisanalytics.model.primitives.FileKey.Type
    object Id extends Subtype[String]
    type Id = zio.aws.kinesisanalytics.model.primitives.Id.Type
    object InAppStreamName extends Subtype[String]
    type InAppStreamName =
      zio.aws.kinesisanalytics.model.primitives.InAppStreamName.Type
    object InAppTableName extends Subtype[String]
    type InAppTableName =
      zio.aws.kinesisanalytics.model.primitives.InAppTableName.Type
    object InputParallelismCount extends Subtype[Int]
    type InputParallelismCount =
      zio.aws.kinesisanalytics.model.primitives.InputParallelismCount.Type
    object KinesisAnalyticsARN extends Subtype[String]
    type KinesisAnalyticsARN =
      zio.aws.kinesisanalytics.model.primitives.KinesisAnalyticsARN.Type
    object ListApplicationsInputLimit extends Subtype[Int]
    type ListApplicationsInputLimit =
      zio.aws.kinesisanalytics.model.primitives.ListApplicationsInputLimit.Type
    object LogStreamARN extends Subtype[String]
    type LogStreamARN =
      zio.aws.kinesisanalytics.model.primitives.LogStreamARN.Type
    object ParsedInputRecordField extends Subtype[String]
    type ParsedInputRecordField =
      zio.aws.kinesisanalytics.model.primitives.ParsedInputRecordField.Type
    object ProcessedInputRecord extends Subtype[String]
    type ProcessedInputRecord =
      zio.aws.kinesisanalytics.model.primitives.ProcessedInputRecord.Type
    object RawInputRecord extends Subtype[String]
    type RawInputRecord =
      zio.aws.kinesisanalytics.model.primitives.RawInputRecord.Type
    object RecordColumnDelimiter extends Subtype[String]
    type RecordColumnDelimiter =
      zio.aws.kinesisanalytics.model.primitives.RecordColumnDelimiter.Type
    object RecordColumnMapping extends Subtype[String]
    type RecordColumnMapping =
      zio.aws.kinesisanalytics.model.primitives.RecordColumnMapping.Type
    object RecordColumnName extends Subtype[String]
    type RecordColumnName =
      zio.aws.kinesisanalytics.model.primitives.RecordColumnName.Type
    object RecordColumnSqlType extends Subtype[String]
    type RecordColumnSqlType =
      zio.aws.kinesisanalytics.model.primitives.RecordColumnSqlType.Type
    object RecordEncoding extends Subtype[String]
    type RecordEncoding =
      zio.aws.kinesisanalytics.model.primitives.RecordEncoding.Type
    object RecordRowDelimiter extends Subtype[String]
    type RecordRowDelimiter =
      zio.aws.kinesisanalytics.model.primitives.RecordRowDelimiter.Type
    object RecordRowPath extends Subtype[String]
    type RecordRowPath =
      zio.aws.kinesisanalytics.model.primitives.RecordRowPath.Type
    object ResourceARN extends Subtype[String]
    type ResourceARN =
      zio.aws.kinesisanalytics.model.primitives.ResourceARN.Type
    object RoleARN extends Subtype[String]
    type RoleARN = zio.aws.kinesisanalytics.model.primitives.RoleARN.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.kinesisanalytics.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.kinesisanalytics.model.primitives.TagValue.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.kinesisanalytics.model.primitives.Timestamp.Type
  }
  type ApplicationSummaries =
    List[zio.aws.kinesisanalytics.model.ApplicationSummary]
  type CloudWatchLoggingOptionDescriptions =
    List[zio.aws.kinesisanalytics.model.CloudWatchLoggingOptionDescription]
  type CloudWatchLoggingOptionUpdates =
    List[zio.aws.kinesisanalytics.model.CloudWatchLoggingOptionUpdate]
  type CloudWatchLoggingOptions =
    List[zio.aws.kinesisanalytics.model.CloudWatchLoggingOption]
  type InAppStreamNames = List[InAppStreamName]
  type InputConfigurations =
    List[zio.aws.kinesisanalytics.model.InputConfiguration]
  type InputDescriptions = List[zio.aws.kinesisanalytics.model.InputDescription]
  type InputUpdates = List[zio.aws.kinesisanalytics.model.InputUpdate]
  type Inputs = List[zio.aws.kinesisanalytics.model.Input]
  type OutputDescriptions =
    List[zio.aws.kinesisanalytics.model.OutputDescription]
  type OutputUpdates = List[zio.aws.kinesisanalytics.model.OutputUpdate]
  type Outputs = List[zio.aws.kinesisanalytics.model.Output]
  type ParsedInputRecord = List[ParsedInputRecordField]
  type ParsedInputRecords = List[Iterable[ParsedInputRecordField]]
  type ProcessedInputRecords = List[ProcessedInputRecord]
  type RawInputRecords = List[RawInputRecord]
  type RecordColumns = List[zio.aws.kinesisanalytics.model.RecordColumn]
  type ReferenceDataSourceDescriptions =
    List[zio.aws.kinesisanalytics.model.ReferenceDataSourceDescription]
  type ReferenceDataSourceUpdates =
    List[zio.aws.kinesisanalytics.model.ReferenceDataSourceUpdate]
  type TagKeys = List[TagKey]
  type Tags = List[zio.aws.kinesisanalytics.model.Tag]
}
