package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.{
  Id,
  ApplicationVersionId,
  ApplicationName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AddApplicationInputProcessingConfigurationRequest(
    applicationName: ApplicationName,
    currentApplicationVersionId: ApplicationVersionId,
    inputId: Id,
    inputProcessingConfiguration: zio.aws.kinesisanalytics.model.InputProcessingConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationInputProcessingConfigurationRequest = {
    import AddApplicationInputProcessingConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationInputProcessingConfigurationRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .currentApplicationVersionId(
        ApplicationVersionId.unwrap(currentApplicationVersionId): java.lang.Long
      )
      .inputId(Id.unwrap(inputId): java.lang.String)
      .inputProcessingConfiguration(
        inputProcessingConfiguration.buildAwsValue()
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalytics.model.AddApplicationInputProcessingConfigurationRequest.ReadOnly =
    zio.aws.kinesisanalytics.model.AddApplicationInputProcessingConfigurationRequest
      .wrap(buildAwsValue())
}
object AddApplicationInputProcessingConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationInputProcessingConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalytics.model.AddApplicationInputProcessingConfigurationRequest =
      zio.aws.kinesisanalytics.model
        .AddApplicationInputProcessingConfigurationRequest(
          applicationName,
          currentApplicationVersionId,
          inputId,
          inputProcessingConfiguration.asEditable
        )
    def applicationName: ApplicationName
    def currentApplicationVersionId: ApplicationVersionId
    def inputId: Id
    def inputProcessingConfiguration
        : zio.aws.kinesisanalytics.model.InputProcessingConfiguration.ReadOnly
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getCurrentApplicationVersionId
        : ZIO[Any, Nothing, ApplicationVersionId] =
      ZIO.succeed(currentApplicationVersionId)
    def getInputId: ZIO[Any, Nothing, Id] = ZIO.succeed(inputId)
    def getInputProcessingConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisanalytics.model.InputProcessingConfiguration.ReadOnly
    ] = ZIO.succeed(inputProcessingConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationInputProcessingConfigurationRequest
  ) extends zio.aws.kinesisanalytics.model.AddApplicationInputProcessingConfigurationRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.kinesisanalytics.model.primitives
        .ApplicationName(impl.applicationName())
    override val currentApplicationVersionId: ApplicationVersionId =
      zio.aws.kinesisanalytics.model.primitives
        .ApplicationVersionId(impl.currentApplicationVersionId())
    override val inputId: Id =
      zio.aws.kinesisanalytics.model.primitives.Id(impl.inputId())
    override val inputProcessingConfiguration
        : zio.aws.kinesisanalytics.model.InputProcessingConfiguration.ReadOnly =
      zio.aws.kinesisanalytics.model.InputProcessingConfiguration
        .wrap(impl.inputProcessingConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationInputProcessingConfigurationRequest
  ): zio.aws.kinesisanalytics.model.AddApplicationInputProcessingConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
