package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.{RoleARN, ResourceARN}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class KinesisFirehoseOutputDescription(
    resourceARN: Option[ResourceARN] = None,
    roleARN: Option[RoleARN] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.KinesisFirehoseOutputDescription = {
    import KinesisFirehoseOutputDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.KinesisFirehoseOutputDescription
      .builder()
      .optionallyWith(
        resourceARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.resourceARN)
      .optionallyWith(
        roleARN.map(value => RoleARN.unwrap(value): java.lang.String)
      )(_.roleARN)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalytics.model.KinesisFirehoseOutputDescription.ReadOnly =
    zio.aws.kinesisanalytics.model.KinesisFirehoseOutputDescription
      .wrap(buildAwsValue())
}
object KinesisFirehoseOutputDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.KinesisFirehoseOutputDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalytics.model.KinesisFirehoseOutputDescription =
      zio.aws.kinesisanalytics.model.KinesisFirehoseOutputDescription(
        resourceARN.map(value => value),
        roleARN.map(value => value)
      )
    def resourceARN: Option[ResourceARN]
    def roleARN: Option[RoleARN]
    def getResourceARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("resourceARN", resourceARN)
    def getRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("roleARN", roleARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.KinesisFirehoseOutputDescription
  ) extends zio.aws.kinesisanalytics.model.KinesisFirehoseOutputDescription.ReadOnly {
    override val resourceARN: Option[ResourceARN] = scala
      .Option(impl.resourceARN())
      .map(value =>
        zio.aws.kinesisanalytics.model.primitives.ResourceARN(value)
      )
    override val roleARN: Option[RoleARN] = scala
      .Option(impl.roleARN())
      .map(value => zio.aws.kinesisanalytics.model.primitives.RoleARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.KinesisFirehoseOutputDescription
  ): zio.aws.kinesisanalytics.model.KinesisFirehoseOutputDescription.ReadOnly =
    new Wrapper(impl)
}
