package zio.aws.kinesisanalytics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateApplicationResponse(
    applicationSummary: zio.aws.kinesisanalytics.model.ApplicationSummary
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.CreateApplicationResponse = {
    import CreateApplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.CreateApplicationResponse
      .builder()
      .applicationSummary(applicationSummary.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalytics.model.CreateApplicationResponse.ReadOnly =
    zio.aws.kinesisanalytics.model.CreateApplicationResponse
      .wrap(buildAwsValue())
}
object CreateApplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.CreateApplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.CreateApplicationResponse =
      zio.aws.kinesisanalytics.model
        .CreateApplicationResponse(applicationSummary.asEditable)
    def applicationSummary
        : zio.aws.kinesisanalytics.model.ApplicationSummary.ReadOnly
    def getApplicationSummary: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisanalytics.model.ApplicationSummary.ReadOnly
    ] = ZIO.succeed(applicationSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.CreateApplicationResponse
  ) extends zio.aws.kinesisanalytics.model.CreateApplicationResponse.ReadOnly {
    override val applicationSummary
        : zio.aws.kinesisanalytics.model.ApplicationSummary.ReadOnly =
      zio.aws.kinesisanalytics.model.ApplicationSummary
        .wrap(impl.applicationSummary())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.CreateApplicationResponse
  ): zio.aws.kinesisanalytics.model.CreateApplicationResponse.ReadOnly =
    new Wrapper(impl)
}
