package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kinesis.model.primitives.{TagValue, TagKey}
import scala.jdk.CollectionConverters.*
final case class Tag(key: TagKey, value: Optional[TagValue] = Optional.Absent) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesis.model.Tag = {
    import Tag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.Tag
      .builder()
      .key(TagKey.unwrap(key): java.lang.String)
      .optionallyWith(
        value.map(value => TagValue.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.Tag.ReadOnly =
    zio.aws.kinesis.model.Tag.wrap(buildAwsValue())
}
object Tag {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kinesis.model.Tag] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.Tag =
      zio.aws.kinesis.model.Tag(key, value.map(value => value))
    def key: TagKey
    def value: Optional[TagValue]
    def getKey: ZIO[Any, Nothing, TagKey] = ZIO.succeed(key)
    def getValue: ZIO[Any, AwsError, TagValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.Tag
  ) extends zio.aws.kinesis.model.Tag.ReadOnly {
    override val key: TagKey =
      zio.aws.kinesis.model.primitives.TagKey(impl.key())
    override val value: Optional[TagValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.kinesis.model.primitives.TagValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.Tag
  ): zio.aws.kinesis.model.Tag.ReadOnly = new Wrapper(impl)
}
