package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kinesis.model.primitives.{
  StreamARN,
  HashKey,
  ShardId,
  StreamName
}
import scala.jdk.CollectionConverters.*
final case class SplitShardRequest(
    streamName: Optional[StreamName] = Optional.Absent,
    shardToSplit: ShardId,
    newStartingHashKey: HashKey,
    streamARN: Optional[StreamARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.SplitShardRequest = {
    import SplitShardRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.SplitShardRequest
      .builder()
      .optionallyWith(
        streamName.map(value => StreamName.unwrap(value): java.lang.String)
      )(_.streamName)
      .shardToSplit(ShardId.unwrap(shardToSplit): java.lang.String)
      .newStartingHashKey(HashKey.unwrap(newStartingHashKey): java.lang.String)
      .optionallyWith(
        streamARN.map(value => StreamARN.unwrap(value): java.lang.String)
      )(_.streamARN)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.SplitShardRequest.ReadOnly =
    zio.aws.kinesis.model.SplitShardRequest.wrap(buildAwsValue())
}
object SplitShardRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.SplitShardRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.SplitShardRequest =
      zio.aws.kinesis.model.SplitShardRequest(
        streamName.map(value => value),
        shardToSplit,
        newStartingHashKey,
        streamARN.map(value => value)
      )
    def streamName: Optional[StreamName]
    def shardToSplit: ShardId
    def newStartingHashKey: HashKey
    def streamARN: Optional[StreamARN]
    def getStreamName: ZIO[Any, AwsError, StreamName] =
      AwsError.unwrapOptionField("streamName", streamName)
    def getShardToSplit: ZIO[Any, Nothing, ShardId] = ZIO.succeed(shardToSplit)
    def getNewStartingHashKey: ZIO[Any, Nothing, HashKey] =
      ZIO.succeed(newStartingHashKey)
    def getStreamARN: ZIO[Any, AwsError, StreamARN] =
      AwsError.unwrapOptionField("streamARN", streamARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.SplitShardRequest
  ) extends zio.aws.kinesis.model.SplitShardRequest.ReadOnly {
    override val streamName: Optional[StreamName] = zio.aws.core.internal
      .optionalFromNullable(impl.streamName())
      .map(value => zio.aws.kinesis.model.primitives.StreamName(value))
    override val shardToSplit: ShardId =
      zio.aws.kinesis.model.primitives.ShardId(impl.shardToSplit())
    override val newStartingHashKey: HashKey =
      zio.aws.kinesis.model.primitives.HashKey(impl.newStartingHashKey())
    override val streamARN: Optional[StreamARN] = zio.aws.core.internal
      .optionalFromNullable(impl.streamARN())
      .map(value => zio.aws.kinesis.model.primitives.StreamARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.SplitShardRequest
  ): zio.aws.kinesis.model.SplitShardRequest.ReadOnly = new Wrapper(impl)
}
