package zio.aws.kinesis.model
import zio.aws.kinesis.model.primitives.{
  NextToken,
  StreamName,
  ListStreamsInputLimit
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListStreamsRequest(
    limit: Optional[ListStreamsInputLimit] = Optional.Absent,
    exclusiveStartStreamName: Optional[StreamName] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.ListStreamsRequest = {
    import ListStreamsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.ListStreamsRequest
      .builder()
      .optionallyWith(
        limit.map(value => ListStreamsInputLimit.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        exclusiveStartStreamName.map(value =>
          StreamName.unwrap(value): java.lang.String
        )
      )(_.exclusiveStartStreamName)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.ListStreamsRequest.ReadOnly =
    zio.aws.kinesis.model.ListStreamsRequest.wrap(buildAwsValue())
}
object ListStreamsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.ListStreamsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.ListStreamsRequest =
      zio.aws.kinesis.model.ListStreamsRequest(
        limit.map(value => value),
        exclusiveStartStreamName.map(value => value),
        nextToken.map(value => value)
      )
    def limit: Optional[ListStreamsInputLimit]
    def exclusiveStartStreamName: Optional[StreamName]
    def nextToken: Optional[NextToken]
    def getLimit: ZIO[Any, AwsError, ListStreamsInputLimit] =
      AwsError.unwrapOptionField("limit", limit)
    def getExclusiveStartStreamName: ZIO[Any, AwsError, StreamName] = AwsError
      .unwrapOptionField("exclusiveStartStreamName", exclusiveStartStreamName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.ListStreamsRequest
  ) extends zio.aws.kinesis.model.ListStreamsRequest.ReadOnly {
    override val limit: Optional[ListStreamsInputLimit] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value =>
        zio.aws.kinesis.model.primitives.ListStreamsInputLimit(value)
      )
    override val exclusiveStartStreamName: Optional[StreamName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exclusiveStartStreamName())
        .map(value => zio.aws.kinesis.model.primitives.StreamName(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.kinesis.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.ListStreamsRequest
  ): zio.aws.kinesis.model.ListStreamsRequest.ReadOnly = new Wrapper(impl)
}
