package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kinesis.model.primitives.{StreamARN, BooleanObject, StreamName}
import scala.jdk.CollectionConverters.*
final case class DeleteStreamRequest(
    streamName: Optional[StreamName] = Optional.Absent,
    enforceConsumerDeletion: Optional[BooleanObject] = Optional.Absent,
    streamARN: Optional[StreamARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.DeleteStreamRequest = {
    import DeleteStreamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.DeleteStreamRequest
      .builder()
      .optionallyWith(
        streamName.map(value => StreamName.unwrap(value): java.lang.String)
      )(_.streamName)
      .optionallyWith(
        enforceConsumerDeletion.map(value => value: java.lang.Boolean)
      )(_.enforceConsumerDeletion)
      .optionallyWith(
        streamARN.map(value => StreamARN.unwrap(value): java.lang.String)
      )(_.streamARN)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.DeleteStreamRequest.ReadOnly =
    zio.aws.kinesis.model.DeleteStreamRequest.wrap(buildAwsValue())
}
object DeleteStreamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.DeleteStreamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.DeleteStreamRequest =
      zio.aws.kinesis.model.DeleteStreamRequest(
        streamName.map(value => value),
        enforceConsumerDeletion.map(value => value),
        streamARN.map(value => value)
      )
    def streamName: Optional[StreamName]
    def enforceConsumerDeletion: Optional[BooleanObject]
    def streamARN: Optional[StreamARN]
    def getStreamName: ZIO[Any, AwsError, StreamName] =
      AwsError.unwrapOptionField("streamName", streamName)
    def getEnforceConsumerDeletion: ZIO[Any, AwsError, BooleanObject] = AwsError
      .unwrapOptionField("enforceConsumerDeletion", enforceConsumerDeletion)
    def getStreamARN: ZIO[Any, AwsError, StreamARN] =
      AwsError.unwrapOptionField("streamARN", streamARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.DeleteStreamRequest
  ) extends zio.aws.kinesis.model.DeleteStreamRequest.ReadOnly {
    override val streamName: Optional[StreamName] = zio.aws.core.internal
      .optionalFromNullable(impl.streamName())
      .map(value => zio.aws.kinesis.model.primitives.StreamName(value))
    override val enforceConsumerDeletion: Optional[BooleanObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enforceConsumerDeletion())
        .map(value => value: BooleanObject)
    override val streamARN: Optional[StreamARN] = zio.aws.core.internal
      .optionalFromNullable(impl.streamARN())
      .map(value => zio.aws.kinesis.model.primitives.StreamARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.DeleteStreamRequest
  ): zio.aws.kinesis.model.DeleteStreamRequest.ReadOnly = new Wrapper(impl)
}
