package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kinesis.model.primitives.{StreamARN, TagKey, StreamName}
import scala.jdk.CollectionConverters.*
final case class RemoveTagsFromStreamRequest(
    streamName: Optional[StreamName] = Optional.Absent,
    tagKeys: Iterable[TagKey],
    streamARN: Optional[StreamARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.RemoveTagsFromStreamRequest = {
    import RemoveTagsFromStreamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.RemoveTagsFromStreamRequest
      .builder()
      .optionallyWith(
        streamName.map(value => StreamName.unwrap(value): java.lang.String)
      )(_.streamName)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        streamARN.map(value => StreamARN.unwrap(value): java.lang.String)
      )(_.streamARN)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.RemoveTagsFromStreamRequest.ReadOnly =
    zio.aws.kinesis.model.RemoveTagsFromStreamRequest.wrap(buildAwsValue())
}
object RemoveTagsFromStreamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.RemoveTagsFromStreamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.RemoveTagsFromStreamRequest =
      zio.aws.kinesis.model.RemoveTagsFromStreamRequest(
        streamName.map(value => value),
        tagKeys,
        streamARN.map(value => value)
      )
    def streamName: Optional[StreamName]
    def tagKeys: List[TagKey]
    def streamARN: Optional[StreamARN]
    def getStreamName: ZIO[Any, AwsError, StreamName] =
      AwsError.unwrapOptionField("streamName", streamName)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
    def getStreamARN: ZIO[Any, AwsError, StreamARN] =
      AwsError.unwrapOptionField("streamARN", streamARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.RemoveTagsFromStreamRequest
  ) extends zio.aws.kinesis.model.RemoveTagsFromStreamRequest.ReadOnly {
    override val streamName: Optional[StreamName] = zio.aws.core.internal
      .optionalFromNullable(impl.streamName())
      .map(value => zio.aws.kinesis.model.primitives.StreamName(value))
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.kinesis.model.primitives.TagKey(item)
      }
      .toList
    override val streamARN: Optional[StreamARN] = zio.aws.core.internal
      .optionalFromNullable(impl.streamARN())
      .map(value => zio.aws.kinesis.model.primitives.StreamARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.RemoveTagsFromStreamRequest
  ): zio.aws.kinesis.model.RemoveTagsFromStreamRequest.ReadOnly = new Wrapper(
    impl
  )
}
