package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kinesis.model.primitives.{
  Data,
  StreamName,
  HashKey,
  SequenceNumber,
  PartitionKey,
  StreamARN
}
import scala.jdk.CollectionConverters.*
final case class PutRecordRequest(
    streamName: Optional[StreamName] = Optional.Absent,
    data: Data,
    partitionKey: PartitionKey,
    explicitHashKey: Optional[HashKey] = Optional.Absent,
    sequenceNumberForOrdering: Optional[SequenceNumber] = Optional.Absent,
    streamARN: Optional[StreamARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.PutRecordRequest = {
    import PutRecordRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.PutRecordRequest
      .builder()
      .optionallyWith(
        streamName.map(value => StreamName.unwrap(value): java.lang.String)
      )(_.streamName)
      .data(
        software.amazon.awssdk.core.SdkBytes.fromByteArrayUnsafe(
          data.toArray[Byte]
        )
      )
      .partitionKey(PartitionKey.unwrap(partitionKey): java.lang.String)
      .optionallyWith(
        explicitHashKey.map(value => HashKey.unwrap(value): java.lang.String)
      )(_.explicitHashKey)
      .optionallyWith(
        sequenceNumberForOrdering.map(value =>
          SequenceNumber.unwrap(value): java.lang.String
        )
      )(_.sequenceNumberForOrdering)
      .optionallyWith(
        streamARN.map(value => StreamARN.unwrap(value): java.lang.String)
      )(_.streamARN)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.PutRecordRequest.ReadOnly =
    zio.aws.kinesis.model.PutRecordRequest.wrap(buildAwsValue())
}
object PutRecordRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.PutRecordRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.PutRecordRequest =
      zio.aws.kinesis.model.PutRecordRequest(
        streamName.map(value => value),
        data,
        partitionKey,
        explicitHashKey.map(value => value),
        sequenceNumberForOrdering.map(value => value),
        streamARN.map(value => value)
      )
    def streamName: Optional[StreamName]
    def data: Data
    def partitionKey: PartitionKey
    def explicitHashKey: Optional[HashKey]
    def sequenceNumberForOrdering: Optional[SequenceNumber]
    def streamARN: Optional[StreamARN]
    def getStreamName: ZIO[Any, AwsError, StreamName] =
      AwsError.unwrapOptionField("streamName", streamName)
    def getData: ZIO[Any, Nothing, Data] = ZIO.succeed(data)
    def getPartitionKey: ZIO[Any, Nothing, PartitionKey] =
      ZIO.succeed(partitionKey)
    def getExplicitHashKey: ZIO[Any, AwsError, HashKey] =
      AwsError.unwrapOptionField("explicitHashKey", explicitHashKey)
    def getSequenceNumberForOrdering: ZIO[Any, AwsError, SequenceNumber] =
      AwsError.unwrapOptionField(
        "sequenceNumberForOrdering",
        sequenceNumberForOrdering
      )
    def getStreamARN: ZIO[Any, AwsError, StreamARN] =
      AwsError.unwrapOptionField("streamARN", streamARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.PutRecordRequest
  ) extends zio.aws.kinesis.model.PutRecordRequest.ReadOnly {
    override val streamName: Optional[StreamName] = zio.aws.core.internal
      .optionalFromNullable(impl.streamName())
      .map(value => zio.aws.kinesis.model.primitives.StreamName(value))
    override val data: Data = zio.aws.kinesis.model.primitives
      .Data(zio.Chunk.fromArray(impl.data().asByteArrayUnsafe()))
    override val partitionKey: PartitionKey =
      zio.aws.kinesis.model.primitives.PartitionKey(impl.partitionKey())
    override val explicitHashKey: Optional[HashKey] = zio.aws.core.internal
      .optionalFromNullable(impl.explicitHashKey())
      .map(value => zio.aws.kinesis.model.primitives.HashKey(value))
    override val sequenceNumberForOrdering: Optional[SequenceNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sequenceNumberForOrdering())
        .map(value => zio.aws.kinesis.model.primitives.SequenceNumber(value))
    override val streamARN: Optional[StreamARN] = zio.aws.core.internal
      .optionalFromNullable(impl.streamARN())
      .map(value => zio.aws.kinesis.model.primitives.StreamARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.PutRecordRequest
  ): zio.aws.kinesis.model.PutRecordRequest.ReadOnly = new Wrapper(impl)
}
