package zio.aws.kinesis.model
import zio.aws.kinesis.model.primitives.{
  NextToken,
  StreamName,
  ShardId,
  Timestamp,
  ListShardsInputLimit,
  StreamARN
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListShardsRequest(
    streamName: Optional[StreamName] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    exclusiveStartShardId: Optional[ShardId] = Optional.Absent,
    maxResults: Optional[ListShardsInputLimit] = Optional.Absent,
    streamCreationTimestamp: Optional[Timestamp] = Optional.Absent,
    shardFilter: Optional[zio.aws.kinesis.model.ShardFilter] = Optional.Absent,
    streamARN: Optional[StreamARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.ListShardsRequest = {
    import ListShardsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.ListShardsRequest
      .builder()
      .optionallyWith(
        streamName.map(value => StreamName.unwrap(value): java.lang.String)
      )(_.streamName)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        exclusiveStartShardId.map(value =>
          ShardId.unwrap(value): java.lang.String
        )
      )(_.exclusiveStartShardId)
      .optionallyWith(
        maxResults.map(value => ListShardsInputLimit.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        streamCreationTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.streamCreationTimestamp)
      .optionallyWith(shardFilter.map(value => value.buildAwsValue()))(
        _.shardFilter
      )
      .optionallyWith(
        streamARN.map(value => StreamARN.unwrap(value): java.lang.String)
      )(_.streamARN)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.ListShardsRequest.ReadOnly =
    zio.aws.kinesis.model.ListShardsRequest.wrap(buildAwsValue())
}
object ListShardsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.ListShardsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.ListShardsRequest =
      zio.aws.kinesis.model.ListShardsRequest(
        streamName.map(value => value),
        nextToken.map(value => value),
        exclusiveStartShardId.map(value => value),
        maxResults.map(value => value),
        streamCreationTimestamp.map(value => value),
        shardFilter.map(value => value.asEditable),
        streamARN.map(value => value)
      )
    def streamName: Optional[StreamName]
    def nextToken: Optional[NextToken]
    def exclusiveStartShardId: Optional[ShardId]
    def maxResults: Optional[ListShardsInputLimit]
    def streamCreationTimestamp: Optional[Timestamp]
    def shardFilter: Optional[zio.aws.kinesis.model.ShardFilter.ReadOnly]
    def streamARN: Optional[StreamARN]
    def getStreamName: ZIO[Any, AwsError, StreamName] =
      AwsError.unwrapOptionField("streamName", streamName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getExclusiveStartShardId: ZIO[Any, AwsError, ShardId] =
      AwsError.unwrapOptionField("exclusiveStartShardId", exclusiveStartShardId)
    def getMaxResults: ZIO[Any, AwsError, ListShardsInputLimit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getStreamCreationTimestamp: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("streamCreationTimestamp", streamCreationTimestamp)
    def getShardFilter
        : ZIO[Any, AwsError, zio.aws.kinesis.model.ShardFilter.ReadOnly] =
      AwsError.unwrapOptionField("shardFilter", shardFilter)
    def getStreamARN: ZIO[Any, AwsError, StreamARN] =
      AwsError.unwrapOptionField("streamARN", streamARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.ListShardsRequest
  ) extends zio.aws.kinesis.model.ListShardsRequest.ReadOnly {
    override val streamName: Optional[StreamName] = zio.aws.core.internal
      .optionalFromNullable(impl.streamName())
      .map(value => zio.aws.kinesis.model.primitives.StreamName(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.kinesis.model.primitives.NextToken(value))
    override val exclusiveStartShardId: Optional[ShardId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exclusiveStartShardId())
        .map(value => zio.aws.kinesis.model.primitives.ShardId(value))
    override val maxResults: Optional[ListShardsInputLimit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.kinesis.model.primitives.ListShardsInputLimit(value)
        )
    override val streamCreationTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streamCreationTimestamp())
        .map(value => zio.aws.kinesis.model.primitives.Timestamp(value))
    override val shardFilter
        : Optional[zio.aws.kinesis.model.ShardFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.shardFilter())
        .map(value => zio.aws.kinesis.model.ShardFilter.wrap(value))
    override val streamARN: Optional[StreamARN] = zio.aws.core.internal
      .optionalFromNullable(impl.streamARN())
      .map(value => zio.aws.kinesis.model.primitives.StreamARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.ListShardsRequest
  ): zio.aws.kinesis.model.ListShardsRequest.ReadOnly = new Wrapper(impl)
}
