package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kinesis.model.primitives.{StreamARN, StreamName}
import scala.jdk.CollectionConverters.*
final case class EnableEnhancedMonitoringResponse(
    streamName: Optional[StreamName] = Optional.Absent,
    currentShardLevelMetrics: Optional[
      Iterable[zio.aws.kinesis.model.MetricsName]
    ] = Optional.Absent,
    desiredShardLevelMetrics: Optional[
      Iterable[zio.aws.kinesis.model.MetricsName]
    ] = Optional.Absent,
    streamARN: Optional[StreamARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.EnableEnhancedMonitoringResponse = {
    import EnableEnhancedMonitoringResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.EnableEnhancedMonitoringResponse
      .builder()
      .optionallyWith(
        streamName.map(value => StreamName.unwrap(value): java.lang.String)
      )(_.streamName)
      .optionallyWith(
        currentShardLevelMetrics.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.currentShardLevelMetricsWithStrings)
      .optionallyWith(
        desiredShardLevelMetrics.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.desiredShardLevelMetricsWithStrings)
      .optionallyWith(
        streamARN.map(value => StreamARN.unwrap(value): java.lang.String)
      )(_.streamARN)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesis.model.EnableEnhancedMonitoringResponse.ReadOnly =
    zio.aws.kinesis.model.EnableEnhancedMonitoringResponse.wrap(buildAwsValue())
}
object EnableEnhancedMonitoringResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.EnableEnhancedMonitoringResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.EnableEnhancedMonitoringResponse =
      zio.aws.kinesis.model.EnableEnhancedMonitoringResponse(
        streamName.map(value => value),
        currentShardLevelMetrics.map(value => value),
        desiredShardLevelMetrics.map(value => value),
        streamARN.map(value => value)
      )
    def streamName: Optional[StreamName]
    def currentShardLevelMetrics
        : Optional[List[zio.aws.kinesis.model.MetricsName]]
    def desiredShardLevelMetrics
        : Optional[List[zio.aws.kinesis.model.MetricsName]]
    def streamARN: Optional[StreamARN]
    def getStreamName: ZIO[Any, AwsError, StreamName] =
      AwsError.unwrapOptionField("streamName", streamName)
    def getCurrentShardLevelMetrics
        : ZIO[Any, AwsError, List[zio.aws.kinesis.model.MetricsName]] = AwsError
      .unwrapOptionField("currentShardLevelMetrics", currentShardLevelMetrics)
    def getDesiredShardLevelMetrics
        : ZIO[Any, AwsError, List[zio.aws.kinesis.model.MetricsName]] = AwsError
      .unwrapOptionField("desiredShardLevelMetrics", desiredShardLevelMetrics)
    def getStreamARN: ZIO[Any, AwsError, StreamARN] =
      AwsError.unwrapOptionField("streamARN", streamARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.EnableEnhancedMonitoringResponse
  ) extends zio.aws.kinesis.model.EnableEnhancedMonitoringResponse.ReadOnly {
    override val streamName: Optional[StreamName] = zio.aws.core.internal
      .optionalFromNullable(impl.streamName())
      .map(value => zio.aws.kinesis.model.primitives.StreamName(value))
    override val currentShardLevelMetrics
        : Optional[List[zio.aws.kinesis.model.MetricsName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentShardLevelMetrics())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kinesis.model.MetricsName.wrap(item)
          }.toList
        )
    override val desiredShardLevelMetrics
        : Optional[List[zio.aws.kinesis.model.MetricsName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.desiredShardLevelMetrics())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kinesis.model.MetricsName.wrap(item)
          }.toList
        )
    override val streamARN: Optional[StreamARN] = zio.aws.core.internal
      .optionalFromNullable(impl.streamARN())
      .map(value => zio.aws.kinesis.model.primitives.StreamARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.EnableEnhancedMonitoringResponse
  ): zio.aws.kinesis.model.EnableEnhancedMonitoringResponse.ReadOnly =
    new Wrapper(impl)
}
